/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
 * $Id: oss.h,v 1.3 2003/06/26 21:13:43 rocko Exp $
 *
 * Copyright (c) 2000, 2001 by Shiman Associates Inc. and Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions: The above
 * copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the names of the authors or
 * copyright holders shall not be used in advertising or otherwise to
 * promote the sale, use or other dealings in this Software without
 * prior written authorization from the authors or copyright holders,
 * as applicable.
 *
 * All trademarks and registered trademarks mentioned herein are the
 * property of their respective owners. No right, title or interest in
 * or to any trademark, service mark, logo or trade name of the
 * authors or copyright holders or their licensors is granted.
 *
 */

#ifndef _ANX_OSS_H
#define _ANX_OSS_H

#define DEFAULT_RES_STATE_ITO_S 10
#define DEFAULT_RES_STATE 2
/*
 * Choosing DEFAULT_BUFTIME_US:
 * 1. Don't make it too large because it gets written all at once to
 *    the soundcard.
 * 2. Taking into account the sample size and channels, this time-size
 *    has to be smaller than PLAY_BUFFER_SIZE.
 * 
 */
#define DEFAULT_BUFTIME_MS      40

#define PLAY_BUFFER_SIZE        176400

/* this is the recording segment length... need to make adjustable */
/* it MUST be an integer multiple of BPSTC */

#define MAS_ANX_SEGLEN 2304      /* 13.06ms */

#define MAX_FRAGSIZE_MS         50 /* give up after this - we probably
                                      can't set the fragment size */ 
#define MIN_FRAGSIZE_US         800 /* minimum fragment size in
                                        microseconds */
#define ALLOCATED_MIX_CH        16


/* these DMA-related parameters aren't used yet. */
#define TARGET_DMABUF_TIME_MS   1000
#define MIN_DMABUF_TIME_MS      50


struct dmainfo
{
    char* buf;
    char* ptr;
    char* dmaptr;
    int   size;
    char* last;
    int   bytes;
};

struct oss_state
{
    int            fd;
    u_int16        fragsize;
    u_int16        fragments;

    int            is_fragment_accurate;
    int            is_mmap_able;
    
#ifdef SNDCTL_DSP_GETERROR /* xrun detection */
    audio_errinfo  errinfo;
#endif

    /* mixer */
    int mfd;
    int oss_mch_map[ALLOCATED_MIX_CH];

    /* is device open and configured? */
    int configured;
    
    /* DMA ***********/
    struct dmainfo* dmaplay;
    struct dmainfo* dmarec;
    int trigger;
    /****************/

};

#endif /* _ANX_OSS_H */
