/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
 * $Id: mas_error.h,v 1.2 2003/06/26 20:52:21 rocko Exp $
 *
 * Copyright (c) 2000, 2001 by Shiman Associates Inc. and Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions: The above
 * copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the names of the authors or
 * copyright holders shall not be used in advertising or otherwise to
 * promote the sale, use or other dealings in this Software without
 * prior written authorization from the authors or copyright holders,
 * as applicable.
 *
 * All trademarks and registered trademarks mentioned herein are the
 * property of their respective owners. No right, title or interest in
 * or to any trademark, service mark, logo or trade name of the
 * authors or copyright holders or their licensors is granted.
 *
 */

#ifndef _MAS_ERROR_H
#define	_MAS_ERROR_H

/* Higher numbers are lower severity */
#define MAS_ERR_CRITICAL 0x10000000 /* CRITICAL ERROR. Bail now! */
#define MAS_ERR_ERROR    0x20000000 /* unrecoverable error condition */
#define MAS_ERR_WARNING  0x30000000 /* recoverable, warning conditions */
#define MAS_ERR_RESERVED 0x40000000 /* [reserved for future use] */
#define MAS_ERR_ALERT    0x50000000 /* possible error or precursor to error */
#define MAS_ERR_INFO     0x60000000 /* informational messages */
#define MAS_ERR_DEBUG    0x70000000 /* debugging messages */
#define MAS_ERR_NONE     0x00000000 /* no severity set (yet) */

/* set the verbosity level waypoints */
#define MAS_VERBLVL_COREERR     0       /* Unrecoverable error that
                                         * shuts down the MAS system */
#define MAS_VERBLVL_ERROR       10      /* Unrecoverable error in
                                         * something non-MAS */ 
#define MAS_VERBLVL_WARNING     20      /* Recoverable problem */
#define MAS_VERBLVL_ALERT       30      /* Possible error or precursor
                                           to one */
#define MAS_VERBLVL_INFO        40      /* Interesting information */
#define MAS_VERBLVL_DEBUG       50      /* Debugging information */
#define MAS_VERBLVL_ALL         255     /* Everything */

/* error layers: Where did this error code come from? */
#define MAS_ERRORLAYER_DEV  0x06000000 /* device */
#define MAS_ERRORLAYER_SCH  0x05000000 /* scheduler */
#define MAS_ERRORLAYER_ASM  0x04000000 /* assembler */
#define MAS_ERRORLAYER_PRO  0x03000000 /* protocol */
#define MAS_ERRORLAYER_LIB  0x02000000 /* client library */
#define MAS_ERRORLAYER_SYS  0x01000000 /* system */

#define mas_get_severity(x)    (x & 0x70000000)
#define mas_set_severity(x, y)    (x & 0x8FFFFFFF | y )
#define mas_get_errorlayer(x)  (x & 0x0F000000)
#define mas_get_derror(x)     ((x & 0x00FF0000) >> 16)
#define mas_get_serror(x)     ((x & 0x0000FF00) >> 8)
#define mas_get_merror(x)      (x & 0x000000FF)
#define mas_make_serror(x)    ((x & 0x000000FF) << 8)
#define mas_make_derror(x)    ((x & 0x000000FF) << 16)
#define mas_error(x)           (x | 0x80000000)

/**************************************************************************
 * MAS ERROR HANDLING
 *
 * API functions and internal functions should return int32 error
 * codes.  Error codes are all negative.  More information about the
 * cause of the error can be revealed through bitwise operations on
 * the value.  The sign bit is used to indicate an error.  If the sign
 * bit isn't set, one assumes that the return code doesn't contain
 * error information.  This means you can use the int32 return to
 * pass legitimate integers in the range [0..2^30].
 *
 * IMPORTANT: When the error code's sign bit is set, the value isn't
 * two's complement.  It's handled by the error functions and defines as
 * if it were an unsigned 32-bit integer.  The reason it's passed as
 * an int32 is that it allows for a simple "is-less-than-zero" error test.
 *
 * The error codes are structured in the following way (bit 0 is LSB):
 *
 * 31   Error flag (set using mas_error() define, please)
 * 30   2 -
 * 29   1  | Three bit loglevel code
 * 28   0 -
 *
 * 27   3 -
 * 26   2  | Four bit layer origination code.
 * 25   1  | 
 * 24   0 -
 *
 * 23  -
 * 22   | 
 * 21   | Device-specific error codes (derror).  Can be interpreted by
 * 20   | devices that can speak the protocol, or by the client API.
 * 19   | 
 * 18   |
 * 17   |
 * 16  -
 *
 * 15  -
 * 14   | 
 * 13   | System-specific error codes (serror) - not sent over the
 * 12   | network.  This is errno on UNIX.
 * 11   |
 * 10   |
 *  9   |
 *  8  -
 *
 *  7  -
 *  6   | 
 *  5   | MAS Error Codes (merror)
 *  4   |
 *  3   |
 *  2   |
 *  1   |
 *  0  -
 *
 *************************************************************************/

#define MERR_ERROR               1  /* generic error */
#define MERR_BIGERROR            2  /* generic big error */
#define MERR_FILE_NOT_FOUND      3  /* file not found */
#define MERR_FILE_CANNOT_OPEN    4  /* can't open file */
#define MERR_MEMORY              5  /* insufficient resources */
#define MERR_EOF                 6  /* end of file */
#define MERR_IO                  7  /* I/O error */
#define MERR_FILE_TYPE           8  /* invalid file type */
#define MERR_INVALID             9  /* invalid argument */
#define MERR_XRUN                10 /* buffer underrun/overrun */
#define MERR_SCHED               11 /* POSIX scheduling error */
#define MERR_COMM                12 /* comm error */
#define MERR_NOSUPP              13 /* NOT SUPPORTED  */
#define MERR_NOTDEF              14 /* not defined */
#define MERR_CANTCREATE          15 /* can't create file/socket */
#define MERR_NULLPTR             16 /* null pointer */
#define MERR_NODATA              17 /* no data */
#define MERR_NOTIMP              18 /* not implemented */
#define MERR_BOUNDS              19 /* bounds error  */

/***********************************************************************
 * MAS Assertions
 *
 * If ASSERT_WARN_ONLY is defined, assertions only print out warning
 * messages.  If not, the ANSI C assert is called, which in turn calls
 * abort().
 *
 */

#include <assert.h>

#ifdef ASSERT_WARN_ONLY
#if defined(__LINE__) && defined(__FILE__)
#define mas_assert(x,msg) do { if (!(x)) masc_log_message(MAS_VERBLVL_ERROR, "assertion failed at %s, line %d: %s", __FILE__, __LINE__, msg); } while (0)
#else
#define mas_assert(x,msg) do { if (!(x)) masc_log_message(MAS_VERBLVL_ERROR, "assertion failed: %s", msg); } while (0)
#endif /* defined line and file */
#else
#define mas_assert(x,msg) do { if (!(x)) { masc_log_message(MAS_VERBLVL_ERROR, "mas_assert: assertion failed: %s\n", msg); assert(x); } } while (0)
#endif


#endif /* _MAS_ERROR_H */

