// Preferences.hh - source file for the mailfilter program
// Copyright (c) 2000 - 2004  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#ifndef PREFERENCES_HH
#define PREFERENCES_HH

#include <string>
#include <vector>
#include <list>
extern "C" {
#include <sys/types.h>
#include <regex.h>
}
#include "RegExp.hh"
#include "mailfilter.hh"

// Filter modes
#define CASE_DEFAULT       0
#define CASE_SENSITIVE     1
#define CASE_INSENSITIVE   2

// Verbose levels
#define MIN_VERBOSE        0
#define MAX_VERBOSE        6

using namespace std;

namespace pref {
  
  struct serverInfo {
    string name;
    string user;
    string pass;
    int protocol;
    int port;
  };


  struct filterInfo {
    string filter;        // Filter as ordinary string object
    int case_sensitive;   // Values can be { CASE_SENSITIVE | CASE_INSENSITIVE | CASE_DEFAULT }

    // Negative filters
    bool negative;        // true if filter is of type 'DENY<>myaddress@something.com', otherwise false

    regex_t cFilter;      // Compiled filter
  };
  

  struct friendInfo {
    string filter;
    regex_t cFilter;
  };


  struct scoreInfo {
    string filter;
    int score;
    int case_sensitive;
    bool negative;
    regex_t cFilter;
  };


  struct Size_score{
    int score;
    int size;
  };


  class Preferences {
  private:
    // Variables
    vector<serverInfo> servers;
    vector<filterInfo> filters;
    vector<friendInfo> friends;
    vector<scoreInfo> scores;
    serverInfo popServer;
    Size_score size_score;
    string logfile;
    string file;
    int highscore;
    int maxsize;
    int maxsizeFriends;
    bool icase;
    bool normal;
    int regType;
    int regNewline;
    int verboseLevel;
    int timeOut;
    bool test;
    bool showHeaders;
    bool delDuplicates;
    bool compiled;
    int maxLineLength;
    re::RegExp regExp;

    // Private function(s)
    int cmpNoCase(const string&, const string&);

  public:
    Preferences(const string&);
    ~Preferences();

    const vector<serverInfo>& getServers(void);
    int getMaxsize(void);
    int getMaxsizeFriends(void);
    bool getIcase(void);
    bool isNormal(void);
    int getVerboseLevel(void);
    void setVerboseLevel(int);
    const string& getLogfile(void);
    void setLogfile(const string&);
    vector<filterInfo>* getFilters(void);
    vector<friendInfo>* getFriends(void);
    vector<scoreInfo>* getScores(void);
    int getRegType(void);
    int getRegNewline(void);
    bool getTestMode(void);
    void setTestMode(bool);
    bool getDelDubs(void);
    bool getShowHeaders(void);
    int getMaxLineLength(void);
    void showErrorDeprecated(const string&);
    void showErrorParameter(const string&, const string&, const string&);
    void showErrorParameter(const string&, const string&, int);
    int getTimeOut(void);
    void setTimeOut(int);
    int getHighscore(void);
    void setHighscore(int);
    void keyword(const string, const string, const string);
    void keyword(const string, const string, int);
    void keyword(const string, int, const string, const string);
    int precompileExpressions(void);
    void setCompiled(bool);
    bool getCompiled(void);
    Size_score getMaxSizeScore(void);
  };
  
  // Exceptions
  class MalformedPrefsFile { };
  class IOException { };
  class RegExException { };
}

#endif
