/*
madman - a music manager
Copyright (C) 2003  Andreas Kloeckner <ak@ixion.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/




#ifndef HEADER_SEEN_PLAYER_XMMS_H
#define HEADER_SEEN_PLAYER_XMMS_H




#include <qtimer.h>
#include <xmmsctrl.h>
#include "utility/player.h"




class tXMMSPlayer : public tPlayer
{
    Q_OBJECT

    int Session;
    bool PreviousPaused,PreviousPlaying;

    bool CurrentSongValid;
    tFilename CurrentSongFilename;

    QTimer Timer;

  public:
    tXMMSPlayer();
    void ensureRunning();
    QString name()
    {
      return "XMMS";
    }
    void playNow(tSongList const &songlist);
    void playNext(tSongList const &songlist);
    void playEventually(tSongList const &songlist);
    void setPlayList(tSongList const &songlist);
    void getPlayList(vector<tFilename> &songs);
    void clearPlaylist() 
    {
      xmms_remote_playlist_clear(Session);
    }

    tFilename currentFilename();
    QString currentTitle();

    bool isPlaying()
    {
      return xmms_remote_is_playing(Session);
    }
    bool isPaused()
    {
      return xmms_remote_is_paused(Session);
    }

    float currentTime();
    float totalTime();

    void play()
    {
      xmms_remote_play(Session);
      timer();
    }
    void stop()
    {
      xmms_remote_stop(Session);
      timer();
    }
    void pause()
    {
      if (!isPaused())
      {
	xmms_remote_pause(Session);
	timer();
      }
    }

    void skipForward()
    {
      xmms_remote_playlist_next(Session);
    }
    void skipBack()
    {
      xmms_remote_playlist_prev(Session);
    }
    void skipToSeconds(float seconds);

  private slots:
    void timer();
    bool haveValidPlaylistPosition();
};




#endif
