
/* Author : Stephen Smalley, <sds@epoch.ncsc.mil> */
/*
 * Updated: Trusted Computer Solutions, Inc. <dgoeddel@trustedcs.com>
 *
 *	Support for enhanced MLS infrastructure.
 *
 * Copyright (C) 2004-2005 Trusted Computer Solutions, Inc.
 */

/* FLASK */

/*
 * Type definitions for the multi-level security (MLS) policy.
 */

#ifndef _MLS_TYPES_H_
#define _MLS_TYPES_H_

#include <stdint.h>
#include <sepol/ebitmap.h>
#include <sepol/sepol.h>
#include <sepol/flask_types.h>

typedef struct mls_level {
	uint32_t sens; 	   /* sensitivity */
	ebitmap_t cat;	   /* category set */
} mls_level_t;

typedef struct mls_range {
	mls_level_t level[2]; /* low == level[0], high == level[1] */
} mls_range_t;

extern int sepol_mls_enabled(void);

static inline int mls_level_eq(struct mls_level *l1, struct mls_level *l2)
{
	if (!sepol_mls_enabled())
		return 1;

	return ((l1->sens == l2->sens) &&
	        ebitmap_cmp(&l1->cat, &l2->cat));
}

static inline int mls_level_dom(struct mls_level *l1, struct mls_level *l2)
{
	if (!sepol_mls_enabled())
		return 1;

	return ((l1->sens >= l2->sens) &&
	        ebitmap_contains(&l1->cat, &l2->cat));
}

#define mls_level_incomp(l1, l2) \
(!mls_level_dom((l1), (l2)) && !mls_level_dom((l2), (l1)))

#define mls_level_between(l1, l2, l3) \
(mls_level_dom((l1), (l2)) && mls_level_dom((l3), (l1)))

#define mls_range_contains(r1, r2) \
(mls_level_dom(&(r2).level[0], &(r1).level[0]) && \
 mls_level_dom(&(r1).level[1], &(r2).level[1]))

#endif

/* FLASK */

