/*
 * Guestbook module for the Roxen Server
 * (c) Kai Voigt, k@123.org
 *
 * http://k.123.org/guestbook.html
 */

string cvs_version = "$Id: guestbook.pike,v 1.4 1998/02/09 09:35:55 k Exp $";

#include <module.h>
inherit "module";

#include <stdio.h>
#include <array.h>
#include <simulate.h>

mapping (string:mapping (string:string)) languages = ([
  "de":(["From":"Von:",
         "Subject":"Betreff:",
         "Date":"Datum:",
         "YourName":"Dein Name:",
         "YourEmail":"Deine Email:",
         "YourSubject":"Dein Betreff:",
         "YourContent":"Dein Kommentar:",
         "Submit":"abschicken!",
         "WannapostMessage":"Selbst Nachricht eingeben!",
         "ThankyouMessage":"Vielen Dank fr Deine Eingabe.",
         "ErrorMessage":"Bitte alle Felder ausf&uuml;llen!",
         "BackMessage":"zur&uuml;ck zum G&auml;stebuch",
			 ]),
  "en":(["From":"From:",
         "Subject":"Subject:",
         "Date":"Date:",
         "YourName":"Your Name:",
         "YourEmail":"Your Email:",
         "YourSubject":"Your Subject:",
         "YourContent":"Your Comments:",
         "Submit":"Send!",
         "WannapostMessage":"Send a message yourself!",
         "ThankyouMessage":"Thank you for your input!",
         "ErrorMessage":"Please fill out every field!",
         "BackMessage":"Back to the guestbook",
			 ]),
  "fr":(["From":"De:",
         "Subject":"Sujet:",
         "Date":"Date:",
         "YourName":"Votre Nom:",
         "YourEmail":"Votre Email:",
         "YourSubject":"Votre Sujet:",
         "YourContent":"Vos commentaires:",
         "Submit":"Envoyer !!!!",
         "WannapostMessage":"Ajoutez vos remarques !",
         "ThankyouMessage":"Merci de nous avoir laiss&eacute; vos remarques !",
         "ErrorMessage":"Merci de remplir chaques cases !",
         "BackMessage":"Retourner au livre d'or",
       ]),
  "hu":(["From":"Felad:",
         "Subject":"Tma:",
         "Date":"Dtum:",
         "YourName":"Neved:",
         "YourEmail":"Email cmed:",
         "YourSubject":"Tma:",
         "YourContent":"Megjegyzs:",
         "Submit":"Mehet!",
         "WannapostMessage":"Berok a vendgknyvbe!",
         "ThankyouMessage":"Ksznjk vlemnyedet.",
         "ErrorMessage":"Krlek, minden mezt tlts ki!",
         "BackMessage":"vissza a vendgknyvhz",
			 ]),
]);

string myfilename = "";
string basedir = "";

string language = "";
string notify = "";

string conf_From = "";
string conf_Subject = "";
string conf_Date = "";
string conf_YourName = "";
string conf_YourEmail = "";
string conf_YourSubject = "";
string conf_YourContent = "";
string conf_Submit = "";
string conf_WannapostMessage = "";
string conf_ThankyouMessage = "";
string conf_ErrorMessage = "";
string conf_BackMessage = "";

mixed *register_module()
{
  return ({ 
    MODULE_PARSER,
    "Guestbook",
      ("Creates a simple guestbook."
			 "<p>This module defines a tag, &lt;guestbook&gt;,"
			 " which can take the lang argument to specify the"
			 " language of the module and the notify argument to"
			 " send a notification email to the specified address."
			 " <p>\n"
			 " All the entries are stored into a subdirectory <tt>gb/</tt>"
			 " of the directory where the file containing the"
			 " &lt;guestbook&gt; tag is."
			 " <br>\n"),
      ({}), 1, });
}

void create()
{
	defvar("Language", "en",
		"Default language", TYPE_MULTIPLE_STRING,
		"The default language of the module, use the lang attribute to"
		" change it in your documents",
		({"en", "de", "fr", "hu"}));
	defvar("HTML_Tags", 0,
	  "allow HTML Tags", TYPE_FLAG,
		"Do you want to let people enter HTML code into their entries?"
		" If set to no, every &lt; will be substituted by &amp;lt;.");
	defvar("sendmail", "/usr/sbin/sendmail",
	       "Sendmail Binary", TYPE_STRING,
	       "This is the location of the sendmail binary.\n");
	defvar("mailaddr", "",
	       "Mail Recipient", TYPE_STRING,
	       "This is the address to send mail notification to when a new "
	       "entry is added. Multiple addresses separated by ','\n"
	       "<br>If left empty, no mailnotification will be done.\n"
				 "<br>This address can be overruled with the notify attribute\n");
}

string|void check_variable(string variable, mixed set_to)
{
  if (variable=="sendmail") {
    if(!file_stat(set_to))
      return "File doesn't exist!";
  }
}

string tag_guestbook(string tag_name, mapping args, object request_id, mapping defines);

mapping query_tag_callers()
{
  return ([ "guestbook" : tag_guestbook ]);
}

string guestbook_list_entry(int number)
{
	string result = "";

	string author = explode(read_file(basedir+"gb/"+number+".txt", 0, 1), "\n")[0];
	string email = explode(read_file(basedir+"gb/"+number+".txt", 1, 1), "\n")[0];
	string date = explode(read_file(basedir+"gb/"+number+".txt", 2, 1), "\n")[0];
	string subject = explode(read_file(basedir+"gb/"+number+".txt", 3, 1), "\n")[0];
	string content = read_file(basedir+"gb/"+number+".txt", 5);

	result += conf_From+" "+author+" (<a href=\"mailto:"+email+"\">"+email+"</a>)<br>\n";
	result += conf_Date+" "+date+"<br>\n";
	result += conf_Subject+" <b>"+subject+"</b><br>\n";
	result += "<pre>\n";
	result += content;
	result += "</pre>\n";
	result += "<hr>\n";
	return result;
}

array guestbook_entries()
{
  array entries = ({});

	string *filenames = get_dir(basedir+"gb/");

	foreach (filenames, string filename) {
		if (reverse(reverse(filename)[..3]) == ".txt") {
			entries += ({(int)reverse(reverse(filename)[4..])});
		}
	}
	entries = sort_array(entries, lambda(int a, int b) { return a < b; });
	return(entries);
}

int guestbook_newnumber()
{
	array entries = guestbook_entries();

	if (entries == ({})) {
		return(1);
	} else {
	  return((int)entries[0]+1);
	}
}

string guestbook_date()
{
	mapping(string:int)date = localtime(time());
	return((string)date["mday"]+"."+(string)(date["mon"]+1)+"."+(string)date["year"]);
}

string guestbook_write_entry(string author, string email, string subject, string content)
{
	string result = "";

	int number = guestbook_newnumber();
	write_file(basedir+"gb/"+number+".txt", author+"\n");
	write_file(basedir+"gb/"+number+".txt", email+"\n");
	string date = guestbook_date();
	write_file(basedir+"gb/"+number+".txt", date+"\n");
	write_file(basedir+"gb/"+number+".txt", subject+"\n");
	write_file(basedir+"gb/"+number+".txt", "\n");
	if ((int)query("HTML_Tags") == 0) {
		content = replace(content, "<", "&lt;");
	}
	write_file(basedir+"gb/"+number+".txt",                     
		sprintf("%-=*s", 60, replace(content, ({"\r\n","\r"}),({"\n","\n"})))+"\n");


	result += conf_ThankyouMessage+"\n";
	result += "<hr>\n";
	result += guestbook_list_entry(number);
	result += "<table><tr><td>";
	result += "<form action=\""+myfilename+"\" method=post>\n";
	result += "<input type=\"submit\" value=\""+conf_BackMessage+"\">\n";
	result += "<input type=hidden name=\"mode\" value=\"list\">";
	result += "</form>\n";
	result += "</td></tr></table>";
	return result;
}

void guestbook_mail_entry(string author, string email, string subject, string contents)
{
  string message = "";

  message += "To: " + notify + "\n";
  message += "X-Mailer: Roxen Guestbook Module\n";
  message += "Subject: New Guestbookentry\n\n";
  message += conf_From + " " + author + " (" + email + ")\n";
  message += conf_Date + " " + guestbook_date() + "\n";
  message += conf_Subject + " " + subject + "\n\n";
  message += contents;

  object in = clone(files.file, "stdout");
  object out = in->pipe();
  if (catch(spawn(query("sendmail")+" -t",out,0,out)))
    perror("Guestbook: Error spawning " + query("sendmail") + "\n");
  in->write(message);
  in->close();

  return;
}

string guestbook_input(string Name, string Email, string Subject, string Content)
{
	string result = "";

	result += "<form action=\""+myfilename+"\" method=post>\n";
	result += "<input type=hidden name=\"mode\" value=\"post\">\n";
	result += "<table cellspacing=10 border=0>\n";
	result += "<tr><td>"+conf_YourName+"</td>\n";
	result += "<td><input value=\""+Name+"\" name=\"Name\" size=\"60\"></td></tr>\n";
	result += "<tr><td>"+conf_YourEmail+"</td>\n";
	result += "<td><input value=\""+Email+"\" name=\"Email\" size=\"60\"></td></tr>\n";
	result += "<tr><td>"+conf_YourSubject+"</td>\n";
	result += "<td><input value=\""+Subject+"\" name=\"Subject\" size=\"60\"></td></tr>\n";
	result += "<tr><td valign=top>"+conf_YourContent+"</td>\n";
	result += "<td><textarea name=\"Content\" cols=60 rows=10 wrap=physical>"+Content+"</textarea></td></tr>\n";
	result += "<tr><td></td><td align=left><input type=submit value=\""+conf_Submit+"\"</td></tr>\n";
	result += "</table>\n";
	result += "</form>\n";
	return result;
}

string guestbook_list()
{
  string liste = "";

	liste += "<table><tr><td>";
	liste += "<form action=\""+myfilename+"\" method=post>\n";
	liste += "<input type=\"submit\" value=\""+conf_WannapostMessage+"\">\n";
	liste += "<input type=hidden name=\"mode\" value=\"input\">";
	liste += "</form>\n";
	liste += "</td></tr></table>";
	liste += "<hr>\n";
  array entries = guestbook_entries();
	foreach(entries, int entry) {
		liste += guestbook_list_entry(entry);
	}
	return liste;
}

string guestbook_wrong_input()
{
	string wrong = "";
  wrong += conf_ErrorMessage+"\n";
	wrong += "<hr>\n";
	return wrong;
}

string guestbook_post(object request_id)
{
  string result = "";
	string Name = "";
	string Email = "";
	string Subject = "";
	string Content = "";

	Name = request_id->variables["Name"];
	Email = request_id->variables["Email"];
	Subject = request_id->variables["Subject"];
	Content = request_id->variables["Content"];

	if ((Name == "") || (Email == "") || (Subject == "") || (Content == "")) {
		result += guestbook_wrong_input();
		result += guestbook_input(Name, Email, Subject, Content); 
		return result;
	} else {
		result += guestbook_write_entry(Name, Email, Subject, Content);
		if (notify != "")
		  guestbook_mail_entry(Name, Email, Subject, Content);
		return result;
	}
}

string tag_guestbook(string tag_name, mapping args, object request_id, mapping defines)
{
	myfilename = (request_id->not_query/"/")[-1];
	basedir = reverse(reverse(explode(request_id->realfile, "/"))[1..])*"/"+"/";
  mkdir(basedir+"gb/"); /* */

	notify = query("mailaddr");
	if (args["notify"]) {
		notify = args["notify"];
	}
	language = query("Language");
	if (args["lang"]) {
		language = args["lang"];
	}
	conf_From = languages[language]["From"];
	conf_Subject = languages[language]["Subject"];
	conf_Date = languages[language]["Date"];
	conf_YourName = languages[language]["YourName"];
	conf_YourEmail = languages[language]["YourEmail"];
	conf_YourSubject = languages[language]["YourSubject"];
	conf_YourContent = languages[language]["YourContent"];
	conf_Submit = languages[language]["Submit"];
	conf_WannapostMessage = languages[language]["WannapostMessage"];
	conf_ThankyouMessage = languages[language]["ThankyouMessage"];
	conf_ErrorMessage = languages[language]["ErrorMessage"];
	conf_BackMessage = languages[language]["BackMessage"];

	if (request_id->variables["mode"]) {
		switch (request_id->variables["mode"]) {
			case "input":
				string result = guestbook_input("", "", "", "");
				return result;
				break;
			case "post":
				string result = guestbook_post(request_id);
				return result;
				break;
			default:
				string result = guestbook_list();
				return result;
				break;
		}
				
	} else {
		string result = guestbook_list();
  	return result;
	}
}
