#!NOMODULE

// This is a roxen module. (c) Martin Baehr 1997

// The form module. 
// parses the <form> container to save it's contents
// for later use by modules to evaluate the input

//  This code is (c) 1996-1997 Martin Baehr, and can be used, modified and
//  redistributed freely under the terms of the GNU General Public License,
//  version 2.
//  This code comes on a AS-IS basis, with NO WARRANTY OF ANY KIND, either
//  implicit or explicit. Use at your own risk.
//  You can modify this code as you wish, but in this case please
//  - state that you changed the code in the modified version
//  - do not remove my name from it
//  - send me a copy of the modified version or a patch, so that
//    I can include it in the 'official' release.
//  If you find this code useful, please e-mail me. It would definitely
//  boost my ego :)
//  
//  For risks and side-effects please read the code or ask your local 
//  unix or roxen-guru.

#include <roxen.h>
inherit "roxenlib";

string cvs_version = "$Id: showdata.pike,v 1.0 1997/11/14 mb Exp $";

mixed main(mapping res, object id)
{
  mapping m,n;
  int i,j;
  string out = "";
  array index, a;

//  perror(sprintf("form: show: res->form: %d", sizeof(res->form)));

  out += "<br>\n";

  for(i=0; i<sizeof(res->form); i++)
  {
    m=res->form[i];
    if (m->tag)
      out += "tag:" + make_tag(m->tag, m->arguments);
      if (m->arguments->type=="hidden")
        out += "hidden:" + m->arguments->name + "=" + m->arguments->value;
    if (m->container == "select")
    {
      perror(sprintf("form: show: select: opt: %d", sizeof(m->opt)));
      string options;
      for(j=0; j<sizeof(m->opt); j++)
      {
        n=m->opt[j];
        if(n->arguments->type=="hidden")
        out += "hidden:" + n->contents + "<br>\n";
        options += make_container(n->container, n->arguments, n->contents) + "\n";
      }
      out += "select: " + make_container(m->container, m->arguments, options);
    }
    else if (m->container == "textarea")
      out += "container:" + make_container(m->container, m->arguments, m->contents);
    out += "<br>\n";
//    perror(sprintf("form: show: i: %d, out: %d", i, sizeof(out)));
  }

//  index=indices(res->data); 
//
//  for(i=0; i<sizeof(index); i++)
//  {
//    a=res->data[index[i]]->value;
//    for(j=0; j<sizeof(a); j++)
//      out += sprintf("%t: %d: %t<br>\n", index[i], j, a[j]);
//  }

  out += sprintf("<pre><hr>\n%O\n<hr>\n%O</pre>", id->variables, res); 

  return http_string_answer(parse_rxml(make_container("form", ([]), out), id), "text/html");
//  return http_string_answer("<form>"+out+"</form>", "text/html");

}
