/*
                           Comfermation Dialog
 */

#ifndef CDIALOG_H
#define CDIALOG_H

#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef gbool
# define gbool	guchar
#endif


/*
 *	Message icon codes, specifies the icon displayed next to
 *	the message:
 */
#define CDIALOG_ICON_INFO	0
#define CDIALOG_ICON_WARNING    1
#define CDIALOG_ICON_ERROR	2
#define CDIALOG_ICON_QUESTION	3


/*
 *	Response codes:
 */
#define CDIALOG_RESPONSE_NOT_AVAILABLE	-1
#define CDIALOG_RESPONSE_NO		0
#define CDIALOG_RESPONSE_YES		1
#define CDIALOG_RESPONSE_YES_TO_ALL	2
#define CDIALOG_RESPONSE_CANCEL		3
#define CDIALOG_RESPONSE_OK		4
#define CDIALOG_RESPONSE_HELP		5


/*
 *	Button flags:
 */
#define CDIALOG_BTNFLAG_OK		(1 << 0)
#define CDIALOG_BTNFLAG_YES		(1 << 1)
#define CDIALOG_BTNFLAG_YES_TO_ALL	(1 << 2)
#define CDIALOG_BTNFLAG_NO		(1 << 3)
#define CDIALOG_BTNFLAG_CANCEL		(1 << 4)
#define CDIALOG_BTNFLAG_IGNORE		(1 << 5)
#define CDIALOG_BTNFLAG_RETRY		(1 << 6)
#define CDIALOG_BTNFLAG_ABORT		(1 << 7)
#define CDIALOG_BTNFLAG_HELP		(1 << 8)


extern gint CDialogInit(void);
extern void CDialogSetTransientFor(GtkWidget *w);
extern gbool CDialogIsQuery(void);
extern void CDialogBreakQuery(void);
extern gint CDialogGetResponse(
	const gchar *title,
	const gchar *message,
	const gchar *explaination,
	gint icon_code,
	guint show_buttons,		/* Any of CDIALOG_BTNFLAG_*. */
	guint default_button		/* One of CDIALOG_BTNFLAG_*. */
);
extern void CDialogMap(void);
extern void CDialogUnmap(void);
extern void CDialogShutdown(void);

#endif	/* CDIALOG_H */
