/***************************************************************************
 $RCSfile: ctdriver_ctapi.h,v $
                             -------------------
    cvs         : $Id: ctdriver_ctapi.h,v 1.2 2003/02/17 04:17:48 aquamaniac Exp $
    begin       : Mon Dec 09 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CTDRIVER_CTAPI_H
#define CTDRIVER_CTAPI_H "$Id"

#ifdef __cplusplus
extern "C" {
#endif


#include <ctcore.h>
#include <chameleon/libloader.h>


#define CTDRIVER_CTAPI_DAD_CT   1
#define CTDRIVER_CTAPI_SAD_HOST 2


typedef char (*CTDCTAPIINITPTR) (unsigned short Ctn, unsigned short pn);
typedef char (*CTDCTAPICLOSEPTR)(unsigned short Ctn);
typedef char (*CTDCTAPIDATAPTR) (unsigned short Ctn,
				 unsigned char  *dad,
				 unsigned char  *sad,
				 unsigned short lc,
				 unsigned char  *cmd,
				 unsigned short *lr,
				 unsigned char  *rsp);

typedef struct CTDRIVERCTAPI_DRIVERDATASTRUCT CTDRIVERCTAPI_DRIVERDATA;
typedef struct CTDRIVERCTAPI_READERDATASTRUCT CTDRIVERCTAPI_READERDATA;

struct CTDRIVERCTAPI_DRIVERDATASTRUCT {
  CTDCTAPIINITPTR init;
  CTDCTAPICLOSEPTR close;
  CTDCTAPIDATAPTR data;
  unsigned int terminalIds;
  CHLIBLOADERHANDLE libHandle;
  CONFIGGROUP *ports; /** not owned ! */
};


struct CTDRIVERCTAPI_READERDATASTRUCT {
  int ctn;
  int isProcessorCard;
};


ERRORCODE CTDriver_CTAPI_Open(CTDRIVERTABLE *dt,
			      CTREADERDESCRIPTION *rd,
			      CONFIGGROUP *ddescr);

ERRORCODE CTDriver_CTAPI_Close(CTDRIVERTABLE *dt);


#ifdef __cplusplus
}
#endif


#endif /* CTDRIVER_CTAPI_H */


