/***************************************************************************
 $RCSfile: ctgeldkarte.cpp,v $
 -------------------
 cvs         : $Id: ctgeldkarte.cpp,v 1.4 2003/04/24 01:43:29 aquamaniac Exp $
 begin       : Sat Dec 21 2002
 copyright   : (C) 2002 by Martin Preuss
 email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_CHIPCARD_DLL
#  define CHIPCARD_API __declspec (dllexport)
# else /* Not BUILDING_CHIPCARD_DLL */
#  define CHIPCARD_API __declspec (dllimport)
# endif /* Not BUILDING_CHIPCARD_DLL */
#else
# define CHIPCARD_API
#endif


#include "ctgeldkarte.h"
#include "ctmisc.h"



/*___________________________________________________________________________
 *AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 * CTGeldKarte::cardData
 *YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY
 */


CTGeldKarte::CardData::CardData()
  :_industrialkey(0)
  ,_shortinstcode(0)
  ,_bestuntil_year(0)
  ,_bestuntil_month(0)
  ,_active_year(0)
  ,_active_month(0)
  ,_active_day(0)
  ,_countrycode(280)
  ,_value(1)
{
}


CTGeldKarte::CardData::CardData(const string &data)
:_industrialkey(0)
,_shortinstcode(0)
,_bestuntil_year(0)
,_bestuntil_month(0)
,_active_year(0)
,_active_month(0)
,_active_day(0)
,_countrycode(280)
,_value(1)
{
#if DEBUGMODE>15
  fprintf(stderr,"CTGeldKarte::CardData::CardData()\n");
#endif

  if (data.length()<22)
    throw CTError("CTGeldKarte::CardData::CardData()",
		  k_CTERROR_INVALID,0,0,
		  "data too small");

  // copy data in
  _industrialkey=CTMisc::bsd2int(data.at(0));
  _shortinstcode=(CTMisc::bsd2int(data.at(1))*10000)+
    (CTMisc::bsd2int(data.at(2))*100)+
    CTMisc::bsd2int(data.at(3));
  _cardnumber.erase();
  _cardnumber=CTMisc::bsd2string(data.substr(4,5));
  _bestuntil_year=CTMisc::bsd2int(data.at(10));
  _bestuntil_month=CTMisc::bsd2int(data.at(11));
  _active_year=CTMisc::bsd2int(data.at(12));
  _active_month=CTMisc::bsd2int(data.at(13));
  _active_day=CTMisc::bsd2int(data.at(14));
  _countrycode=(CTMisc::bsd2int(data.at(15))*100)+
    CTMisc::bsd2int(data.at(16));
  _currency=data.substr(17,3);
  _value=(unsigned char)(data[20]);
  CTMisc::removeBlanks(_currency);
}


CTGeldKarte::CardData::~CardData(){
}







CTGeldKarte::CTGeldKarte(const CTCard &c)
:CTProcessorCard(c)
{
}


CTGeldKarte::~CTGeldKarte(){
}


CTError CTGeldKarte::_openCard(){
  CTError err;
  string response;

  // select master file
  err=selectMF(response);
  if (!err.isOk())
    return CTError("CTGeldKarte::_openCard",err);

  // check for the EF_ID file
  err=selectEF(response, 0x0003);
  if (!err.isOk())
    return CTError("CTGeldKarte::_openCard",err);
  // read EF_ID
  err=execCommand("read_record",
		_cmdReadRecord,
		response,
		"1",
		"256");
  if (!err.isOk())
    return CTError("CTGeldKarte::_openCard",err);
  // locally save EF_ID
  _ef_id=CardData(response);

  err=selectDF(response, 0xa200);
  if (!err.isOk())
    return CTError("CTGeldKarte::_openCard",err);
  return CTError();
}


CTError CTGeldKarte::reopenCard(){
  return _openCard();
}


string CTGeldKarte::cardType(){
  return "CTGeldKarte";
}


string CTGeldKarte::cardTypes(){
  return CTProcessorCard::cardTypes()+",CTGeldKarte";
}


CTError CTGeldKarte::openCard(){
  CTError err;

  err=CTProcessorCard::openCard();
  if (!err.isOk())
    return CTError("CTGeldKarte::openCard",err);
  err=_openCard();
  if (!err.isOk()) {
    CTProcessorCard::closeCard();
    return CTError("CTGeldKarte::openCard",err);
  }
  return CTError();
}


double CTGeldKarte::readLoadedValue(){
  CTError err;
  string response;
  double result;
  int i;

  // check for the EF_BETRAG file
  err=selectEF(response, 0x0104);
  if (!err.isOk())
    throw CTError("CTGeldKarte::readLoadedValue",err);
  // read EF_ID
  err=execCommand("read_record",
		_cmdReadRecord,
		response,
		"1",
		"256");
  if (!err.isOk())
    throw CTError("CTGeldKarte::readLoadedValue",err);

  i=(CTMisc::bsd2int(response.at(0))*10000)+
    (CTMisc::bsd2int(response.at(1))*100)+
    CTMisc::bsd2int(response.at(2));
  result=i;
  switch(_ef_id.value()) {
  case 0x01:
    result/=100;
    break;
  case 0x02:
    result/=10;
    break;
  case 0x08:
    result*=10;
    break;
  case 0x10:
    result*=100;
    break;
  case 0x20:
    result*=1000;
    break;
  default:
    break;
  } // switch

  return result;
}


double CTGeldKarte::readMaxLoadedValue(){
  CTError err;
  string response;
  double result;
  int i;

  // check for the EF_BETRAG file
  err=selectEF(response, 0x0104);
  if (!err.isOk())
    throw CTError("CTGeldKarte::readMaxLoadedValue",err);
  // read EF_ID
  err=execCommand("read_record",
		_cmdReadRecord,
		response,
		"1",
		"256");
  if (!err.isOk())
    throw CTError("CTGeldKarte::readMaxLoadedValue",err);

  i=(CTMisc::bsd2int(response.at(3))*10000)+
    (CTMisc::bsd2int(response.at(4))*100)+
    CTMisc::bsd2int(response.at(5));
  result=i;
  switch(_ef_id.value()) {
  case 0x01:
    result/=100;
    break;
  case 0x02:
    result/=10;
    break;
  case 0x08:
    result*=10;
    break;
  case 0x10:
    result*=100;
    break;
  case 0x20:
    result*=1000;
    break;
  default:
    break;
  } // switch

  return result;
}


double CTGeldKarte::readMaxTransactionValue(){
  CTError err;
  string response;
  double result;
  int i;

  // check for the EF_BETRAG file
  err=selectEF(response, 0x0104);
  if (!err.isOk())
    throw CTError("CTGeldKarte::readMaxTransactionValue",err);
  // read EF_ID
  err=execCommand("read_record",
		_cmdReadRecord,
		response,
		"1",
		"256");
  if (!err.isOk())
    throw CTError("CTGeldKarte::readMaxTransactionValue",err);

  i=(CTMisc::bsd2int(response.at(6))*10000)+
    (CTMisc::bsd2int(response.at(7))*100)+
    CTMisc::bsd2int(response.at(8));
  result=i;
  switch(_ef_id.value()) {
  case 0x01:
    result/=100;
    break;
  case 0x02:
    result/=10;
    break;
  case 0x08:
    result*=10;
    break;
  case 0x10:
    result*=100;
    break;
  case 0x20:
    result*=1000;
    break;
  default:
    break;
  } // switch

  return result;
}








