# $Id: hbcicard.cmd,v 1.8 2003/04/22 22:59:21 aquamaniac Exp $
# This file contains command descriptions for HBCI cards (DDV 0 and 1)

#
# SelectID() for Kobil
#
[kobil/HBCICard/select_file_id]
arguments=1
apdu="apdu1"

[kobil/HBCICard/select_file_id/apdu1]
cla="0"
ins="0xa4"
p1="0x4"
p2=0
data="$data"
lr=255

[kobil/HBCICard/select_file_id/data]
argument=0
type="bin"
min=1
max=64


#
# SelectID() for Towitoko
#
[towitoko/HBCICard/select_file_id]
arguments=1
apdu="apdu1"

[towitoko/HBCICard/select_file_id/apdu1]
cla="0"
ins="0xa4"
p1="0x4"
p2=0
data="$data"
lr=255

[towitoko/HBCICard/select_file_id/data]
argument=0
type="bin"
min=1
max=64


#
# SelectID() for cyberjack
#
[cyberjack/HBCICard/select_file_id]
arguments=1
apdu="apdu1"

[cyberjack/HBCICard/select_file_id/apdu1]
cla="0"
ins="0xa4"
p1="0x4"
p2=0
data="$data"
lr=255

[cyberjack/HBCICard/select_file_id/data]
argument=0
type="bin"
min=1
max=64



#
# Read_EF_ID()
#
[all/HBCICard/read_ef_id]
arguments=0
apdu="apdu1"

[all/HBCICard/read_ef_id/apdu1]
cla="0"
ins="0xb2"
p1="0x01"
p2="0xcc"
lr=255


#
# Read_EF_BNK()
#
[all/HBCICard/read_ef_bnk]
arguments=1
apdu="apdu1"

[all/HBCICard/read_ef_bnk/apdu1]
cla="0"
ins="0xb2"
p1="$num"
p2="0xd4"
lr=255

[all/HBCICard/read_ef_bnk/num]
argument=0
type="uchar"
min=1
max=255


#
# Update_EF_BNK()
#
[all/HBCICard/update_ef_bnk]
arguments=1
apdu="apdu1"

[all/HBCICard/update_ef_bnk/apdu1]
cla="0"
ins="0xdc"
p1="$num"
p2="0xd4"
lr=255

[all/HBCICard/update_ef_bnk/num]
argument=0
type="uchar"
min=1
max=255


#
# Verify_Pin()
#
[all/HBCICard/verify_pin]
arguments=2
apdu="apdu1"

[all/HBCICard/verify_pin/apdu1]
cla="0"
ins="0x20"
p1="0x00"
p2="$kid"
data="$pin"
lr=0

[all/HBCICard/verify_pin/kid]
# key 0x81 is used for the DF_BANKING key
argument=0
type="uchar"

[all/HBCICard/verify_pin/pin]
argument=1
type="fpin2"
min=4
max=8


#
# Secure_Verify_Pin() for Cyberjack
#
[cyberjack/HBCICard/secure_verify_pin]
arguments=1
apdu="apdu1"

[cyberjack/HBCICard/secure_verify_pin/apdu1]
cla="0x20"
ins="0x18"
p1="0x01"
p2="0x00"
data="52 0f 02 06 00 20 00",$kid,"08 ffffffffffffffff"
lr=0

[cyberjack/HBCICard/secure_verify_pin/kid]
argument=0
type="uchar"


#
# Secure_Verify_Pin()
#
[all/HBCICard/secure_verify_pin]
arguments=1
apdu="apdu1"

[all/HBCICard/secure_verify_pin/apdu1]
cla="0x20"
ins="0x18"
p1="0x01"
p2="0x00"
data="52 0f 02 07 00 20 00",$kid,"08 28 ffffffffffffff"
lr=0

[all/HBCICard/secure_verify_pin/kid]
argument=0
type="uchar"


#
#
#
[all/HBCICard/put_inst_data]
arguments=2
apdu="apdu1"

[all/HBCICard/put_inst_data/apdu1]
cla="0x00"
ins="0xdc"
p1="$num"
p2="0xd4"
data="$data"
lr=0

[all/HBCICard/put_inst_data/num]
argument=0
type="uchar"

[all/HBCICard/put_inst_data/data]
argument=1
type="bin"
min=88


