package Lire::Config::Reference;

use strict;

use base qw/Lire::Config::Scalar/;

use Carp;

=pod

=head1 NAME

Lire::Config::Reference - Scalar which points to an Index.

=head1 SYNOPSIS

  use Lire::Config::Reference;

=head1 DESCRIPTION

This is a scalar coming from a Lire::Config::ReferenceSpec and that
will return the referenced entry in the Index when as_value() is called.

=cut

sub new {
    my $self = shift->SUPER::new(@_);

    croak "'spec' parameter should be a Lire::Config::ReferenceSpec instance"
      unless $self->{'spec'}->isa( "Lire::Config::ReferenceSpec" );

    return $self;
}

sub as_value {
    my $self = $_[0];

    return $self->{'spec'}->as_value( $self->get() );
}

1; # whine, whine

__END__

=pod

=head1 AUTHOR

 Francis J. Lacoste <flacoste@logreport.org>

=head1 VERSION

$Id: Reference.pm,v 1.1 2004/07/10 23:39:53 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2004 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
