/***************************************************************************
                          |FILENAME|  -  description
                             -------------------
    begin                : |DATE|
    copyright            : (C) |YEAR| by |AUTHOR|
    email                : |EMAIL|
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "ctxfunctions.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qimage.h>

#include "cledbutton.h"
/* 
 *  Constructs a CTxFunctions which is a child of 'parent', with the 
 *  name 'name'.' 
 */
CTxFunctions::CTxFunctions( QWidget* parent,  const char* name )
    : QGroupBox( parent, name )
{
    setFrameShape( QGroupBox::NoFrame );

//    Tune = new QPushButton( this, "Tune" );
//    Tune->setFlat( FALSE );

//    CWId = new QPushButton( this, "CWId" );

    RXTX = new CLedButton( this, "RXTX" );
    connect(RXTX,SIGNAL(startRx()),this,SIGNAL(startRx()));
    connect(RXTX,SIGNAL(startTx()),this,SIGNAL(startTx()));
    languageChange();
}

/*
 *  Destroys the object and frees any allocated resources
 */
CTxFunctions::~CTxFunctions()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void CTxFunctions::languageChange()
{
//    Tune->setText( tr( "Tune" ) );
//    CWId->setText( tr( "Send CWId" ) );
}

void CTxFunctions::resizeEvent( QResizeEvent * )
{
calculateSizeofComponents();
}

void CTxFunctions::calculateSizeofComponents()
{
#define LEFTANDRIGHTMARGINS 5
#define TOPMARGIN 15
#define NORMALLABELHEIGHT 15
#define distance 7

int xpos,ypos,width,height,innerheight,innerwidth;
width=this->width();
height=this->height();
xpos=width*LEFTANDRIGHTMARGINS/100;
ypos=height*TOPMARGIN/100;
innerwidth=width-2*xpos;
//innerheight=height*NORMALLABELHEIGHT/100;
/** Tune **/
//Tune->setGeometry(xpos,2*ypos,innerwidth,innerheight);

/** Send CWId **/
//ypos=ypos+innerheight+height*distance/100;
//CWId->setGeometry(xpos,ypos,innerwidth,innerheight);

/** RXTX **/
//ypos=ypos+innerheight+height*distance/100;
innerheight=height-ypos-height*TOPMARGIN/100;
RXTX->setGeometry(xpos,ypos,innerwidth,innerheight);

}
