import unittest, gettext, os, linda, tempfile, shutil
from po_count import POFileParser
from linda.collector import Collector
from linda.debug import dprint
from linda.funcs import iterate_dir
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks
from linda.parser.dsc import file_or_sym
from sets import Set

linda.checks = Checks()

class ExampleFilesCheckSourceTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/example_files.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['source'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        self.cur_dir = os.getcwd()
        self.po_keys = POFileParser('po/en.po')
        
    def tearDown(self):
        os.chdir(self.cur_dir)
        shutil.rmtree(self.instance.information['dir'])
        
    def test_example_files(self):
        "Check the sanity of ExamplesFilesCheck"
        method = getattr(self.instance, 'example_files')
        os.makedirs(os.path.join(self.instance.information['dir'], \
            'debian/config/debian'))
        for file in ('debian/ex.lala', 'debian/config/debian/files', \
            'config.cache'):
            f = open(os.path.join(self.instance.information['dir'], file), \
                'w')
            f.close()
        os.chdir(self.instance.information['dir'])
        self.instance.information['collector'] = Collector('src', \
            self.instance.information['dir'], filter(file_or_sym, \
            iterate_dir('.')))
        errors = Set(('examples-files', 'autoconf-generated-files'))
        method()
        self.assert_('debian-files-found' not in self.instance.err_dict.keys())
        self.assertEqual(errors.intersection(self.instance.err_dict.keys()), \
            errors)
        for key in errors:
            self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
                key), True)
        shutil.rmtree(os.path.join(self.instance.information['dir'], \
            'debian/config'))
        os.makedirs(os.path.join(self.instance.information['dir'], 'source', \
            'debian'))
        f = open(os.path.join(self.instance.information['dir'], \
            'source/debian/files'), 'w')
        f.close()
        self.instance.information['collector'] = Collector('src', \
            self.instance.information['dir'], filter(file_or_sym, \
            iterate_dir('.')))
        method()
        self.assert_('debian-files-found' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'debian-files-found'), True)
        for dir in ('debian', 'source'):
            shutil.rmtree(os.path.join(self.instance.information['dir'], dir))
        os.remove(os.path.join(self.instance.information['dir'], 'config.cache'))
        self.instance.err_dict.clear()
        os.mkdir(os.path.join(self.instance.information['dir'], 'debian'))
        f = open(os.path.join(self.instance.information['dir'], 'debian', \
            'hyperlatex.dirs'), 'w')
        f.close()
        self.instance.information['collector'] = Collector('src', \
            self.instance.information['dir'], filter(file_or_sym, \
            iterate_dir('.')))
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        os.unlink(os.path.join(self.instance.information['dir'], 'debian', \
            'hyperlatex.dirs'))
        f = open(os.path.join(self.instance.information['dir'], 'debian', \
            'examples'), 'w')
        f.close()
        self.instance.information['collector'] = Collector('src', \
            self.instance.information['dir'], filter(file_or_sym, \
            iterate_dir('.')))
        method()
        os.unlink(os.path.join(self.instance.information['dir'], 'debian', \
            'examples'))
        self.assertEqual(self.instance.err_dict.keys(), [])
        f = open(os.path.join(self.instance.information['dir'], 'debian', \
            'exim4.dirs'), 'w')
        f.close()
        self.instance.information['collector'] = Collector('src', \
            self.instance.information['dir'], filter(file_or_sym, \
            iterate_dir('.')))
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        shutil.rmtree(os.path.join(self.instance.information['dir'], 'debian'))


        
