import unittest, gettext, os, linda
from po_count import POFileParser
from linda.debug import dprint
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks
from sets import Set

linda.checks = Checks()

class ControlCheckSourceTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/control.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['source'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.po_keys = POFileParser('po/en.po')
        
    def test_build_depends(self):
        "Check build_depends() method of ControlCheck"
        method = getattr(self.instance, 'build_depends')
        self.instance.information['control'] = {'self': [{'build-depends': \
            {'debhelper': {'arch': '', 'relation': ''}}}]}
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        self.instance.information['control']['self'][0]['build-depends'] = \
            {'debhelper': {'arch': ['some'], 'relation': ''}}
        method()
        self.assert_('invalid-arch-in-b-d' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'invalid-arch-in-b-d'), True)
        self.instance.information['control']['self'][0]['build-depends'] = \
            {'automake': {'arch': '', 'relation': ''}}
        method()
        self.assert_('package-b-d-on-autostar' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'package-b-d-on-autostar'), True)

    def test_source(self):
        "Check source() method of ControlCheck"
        method = getattr(self.instance, 'source')
        self.instance.information['control'] = {'self': [{'essential': \
            'maybe'}]}
        method()
        self.assert_('essential-field-in-source' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'essential-field-in-source'), True)
        self.instance.information['control']['self'][0] = {}
        method()
        self.assert_('no-source-field-in-source' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'no-source-field-in-source'), True)
        self.instance.err_dict.clear()
        self.instance.information['control']['self'][0]['description'] = \
           ['foo\n', ' foobar\n']
        method()
        self.assert_('dangerous-char-in-control' not in \
           self.instance.err_dict.keys())
        self.instance.information['control']['self'][0]['section'] = ['games']
        method()
        self.assert_('dangerous-char-in-control' not in \
            self.instance.err_dict.keys())
        self.instance.information['control']['self'][0]['source'] = \
            '%s%s' % (chr(129), chr(176))
        method()
        expected_errs = Set(('bad-source-field', 'source-not-like-package', \
            'dangerous-char-in-control'))
        self.assertEqual(expected_errs.intersection(self.instance.err_dict.keys()), expected_errs)
        for key in expected_errs:
            self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
                key), True)
        self.instance.err_dict.clear()
        self.instance.information['control']['self'][0]['architecture'] = 'all'
        method()

