import unittest, shutil, tempfile
from linda.funcs import run_external_cmd
from linda.parser.changes import ChangesParser
from sets import Set

class ChangesParserTest(unittest.TestCase):
    def setUp(self):
        self.dir = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/parser_changes.tar.gz' % self.dir)

    def tearDown(self):
        shutil.rmtree(self.dir)

    def test_unsigned(self):
        "Check that an unsigned changes files parses"
        chg = ChangesParser('%s/feh_1.1.1-2_i386.changes' % self.dir)
        keys = Set(('files', 'binary', 'changed-by', 'maintainer', \
            'description', 'format', 'source', 'version', 'architecture', \
            'date', 'distribution', 'urgency'))
        self.assertEqual(keys.intersection(chg[0].keys()), keys)
        self.assertEqual(chg[0]['binary'], 'feh')
        self.assertEqual(chg[0]['changed-by'], 'Laurence J. Lane <ljlane@debian.org>')
        self.assertEqual(chg[0]['maintainer'], 'Laurence J. Lane <ljlane@debian.org>')
        self.assertEqual(chg[0]['description'], 'feh        - imlib2 based image viewer')
        self.assertEqual(chg[0]['format'], '1.7')
        self.assertEqual(chg[0]['source'], 'feh')
        self.assertEqual(chg[0]['architecture'], 'source i386')
        self.assertEqual(chg[0]['urgency'], 'low')
        self.assertEqual(chg[0]['date'], 'Sat, 20 Jan 2002 22:05:10 -0500')
        self.assertEqual(len(chg[0]['files']), 4)
        self.assertEqual(chg[0]['files'], [['9deaa264a875603a5b86881dd271cfa5', '635', 'graphics', 'optional', '%s/feh_1.1.1-2.dsc' % self.dir], ['959c595fa9601ef9fe8e54bcc832367f', '465873', 'graphics', 'optional', '%s/feh_1.1.1.orig.tar.gz' % self.dir], ['8494c3b28196099b5608604032839158', '3226', 'graphics', 'optional', '%s/feh_1.1.1-2.diff.gz' % self.dir], ['f9c978041a2e97b93fd0c75be3011039', '383836', 'graphics', 'optional', '%s/feh_1.1.1-2_i386.deb' % self.dir]])

    def test_signed(self):
        "Check that a signed changes file parses"
        chg = ChangesParser('%s/feh_1.1.1-1_i386.changes' % self.dir)
        keys = Set(('files', 'binary', 'changed-by', 'maintainer', \
            'description', 'format', 'source', 'version', 'architecture', \
            'date', 'distribution', 'urgency'))
        self.assertEqual(keys.intersection(chg[0].keys()), keys)
        self.assertEqual(chg[0]['binary'], 'feh')
        self.assertEqual(chg[0]['changed-by'], 'Laurence J. Lane <ljlane@debian.org>')
        self.assertEqual(chg[0]['maintainer'], 'Laurence J. Lane <ljlane@debian.org>')
        self.assertEqual(chg[0]['description'], 'feh        - imlib2 based image viewer')
        self.assertEqual(chg[0]['format'], '1.7')
        self.assertEqual(chg[0]['source'], 'feh')
        self.assertEqual(chg[0]['architecture'], 'source i386')
        self.assertEqual(chg[0]['urgency'], 'low')
        self.assertEqual(chg[0]['date'], 'Sat, 19 Jan 2002 20:15:10 -0500')
        self.assertEqual(len(chg[0]['files']), 4)
        self.assertEqual(chg[0]['files'], [['9deaa264a875603a5b86881dd271cfa5', '635', 'graphics', 'optional', '%s/feh_1.1.1-1.dsc' % self.dir], ['959c595fa9601ef9fe8e54bcc832367f', '465873', 'graphics', 'optional', '%s/feh_1.1.1.orig.tar.gz' % self.dir], ['8494c3b28196099b5608604032839158', '3226', 'graphics', 'optional', '%s/feh_1.1.1-1.diff.gz' % self.dir], ['f9c978041a2e97b93fd0c75be3011039', '383836', 'graphics', 'optional', '%s/feh_1.1.1-1_i386.deb' % self.dir]])

