import sys, os, unittest, linda, tempfile, random
from linda import clparser
from linda.output import OutputFormats
from linda.parser.clparser import CLParser

class BrandenOutputTest(unittest.TestCase):
    def setUp(self):
        self.filename = tempfile.mkstemp()[1]
        linda.outputformats = OutputFormats()
        execfile('output/branden.py')
        for klass in linda.outputformats.registry.keys():
            self.instance = linda.outputformats.registry[klass]()
        clparser = CLParser()
        
    def tearDown(self):
        os.unlink(self.filename)
        
    def test_output(self):
        "Check the output BrandenOutput gives"
        f = open(self.filename, 'w')
        sys.stdout = f
        self.instance.pkg_name = 'test'
        self.instance.type_char = 'E'
        self.instance.description = ['Lala']
        self.instance.data = []
        method = getattr(self.instance, 'print_short')
        method()
        f.close()
        sys.stdout = sys.__stdout__
        f = open(self.filename)
        data = []
        for line in f:
            data.append(line[:-1])
        self.assertEqual(data[0], "E: TEST; LALA")
        self.assert_(data[1] in self.instance.branden)
        f.close()
        f = open(self.filename, 'w')
        f.close()

    def test_output_data(self):
        "Check the output BrandenOutput gives with data provided"
        f = open(self.filename, 'w')
        sys.stdout = f
        self.instance.pkg_name = 'test'
        self.instance.type_char = 'E'
        self.instance.description = ['%s Lala %s']
        self.instance.data = ['a', 'b']
        method = getattr(self.instance, 'print_short')
        method()
        f.close()
        sys.stdout = sys.__stdout__
        f = open(self.filename)
        data = []
        for line in f:
            data.append(line[:-1])
        self.assertEqual(data[0], "E: TEST; A LALA B")
        self.assert_(data[1] in self.instance.branden)
        f.close()
        f = open(self.filename, 'w')
        f.close()

    def test_long_output(self):
        "Check the long output BrandenOutput gives"
        f = open(self.filename, 'w')
        sys.stdout = f
        self.instance.description = ['', ' Lala foo bar']
        method = getattr(self.instance, 'print_long')
        method()
        f.close()
        sys.stdout = sys.__stdout__
        f = open(self.filename)
        k = f.readline()
        self.assertEqual(k, " LALA FOO BAR\n")
        f.close()
        f = open(self.filename, 'w')
        f.close()

