import gettext
from linda.debug import dprint
_ = gettext.gettext

class RFC822Parser:
    def __init__(self, file):
        self.file = file
        self.data = [[]]
        self.empty_stanzas = 0
        self.read()
        self.parse()
        
    def read(self):
        try:
            f = open(self.file)
        except IOError, e:
            raise IOError('failed to parse %s, due to %s.' % (self.file, e))
        tmp_counter = 0
        for k in f:
            if not k.strip():
                tmp_counter += 1
                self.data.append([])
                continue
            if k.startswith('#'):
                continue
            self.data[tmp_counter].append(k)
        f.close()
        for x in range(len(self.data) - 1, -1, -1):
            if self.data[x] == []:
                self.empty_stanzas += 1
                del self.data[x]
        self.concat()
        dprint(_("Parsed array: %s") % self.data, 4)
    
    def validate(self, validtags):
        to_del = []
        for stanza in range(len(self.data)):
            seen = 0
            for line in self.data[stanza]:
                for data in validtags:
                    if line.startswith(data):
                        seen += 1
            if seen < len(validtags):
                to_del.insert(0, stanza)
        for number in to_del:
            del self.data[number]
        dprint(_("Parsed array, after deleting: %s") % self.data, 4)

    def concat(self):
        for x in self.data:
            for y in range(len(x) - 1, 0, -1):
                if x[y].startswith(' ') or x[y].startswith('\t'):
                    x[y-1] += x[y]
                    del x[y]

    def split(self):
        tmp_data = []
        for x in self.data:
            tmp_data.append({})
        for stanza in range(len(self.data)):
            for line in self.data[stanza]:
                preformatted_line = line
                if line.endswith('\n'):
                    preformatted_line = line[:-1]
                cur_line = preformatted_line.split(':', 1)
                tmp_rhs = cur_line[1]
                if tmp_rhs.startswith(' '):
                    tmp_rhs = cur_line[1][1:]
                tmp_data[stanza][cur_line[0].lower()] = tmp_rhs
        self.data = tmp_data
        dprint(_("Parsed array, after converting: %s") % self.data, 4)

    def remove_signed(self):
        if len(self.data) == 4:
            for i in (3, 2, 0):
                del self.data[i]

    def parse(self):
        pass
    
    def __getitem__(self, item):
        return self.data[item]

    def has_key(self, key):
        return self.data.has_key(key)

    def keys(self):
        return self.data.keys()

