import gettext
from linda.debug import dprint
from linda.parser.rfc822parser import RFC822Parser
_ = gettext.gettext

class OverrideParser(RFC822Parser):
    def parse(self):
        self.validate(('Tag:',))
        if not self.data:
            raise OverrideParserException, "Badly-formatted file %s" % \
                self.file
        output_var = {}
        for x in self.data:
            parse_dict = {'tag': '', 'key': '', 'value': ''}
            for k in x:
                if k.find(':') != -1:
                    cur_line = k.split(':')
                    parse_dict['key'] = cur_line[0]
                    value = cur_line[1]
                    if value.endswith('\n'):
                        value = cur_line[1][:-1]
                    parse_dict['value'] = value.strip()
                elif k.startswith('#'):
                    continue
                if k.startswith('Tag:'): 
                    parse_dict['tag'] = parse_dict['value']
                    output_var[parse_dict['tag']] = {}
                    dprint(_("Found tag: %s.") % parse_dict['tag'], 4)
                elif k.startswith('Type:') or k.startswith('Data:'):
                    dprint(_("Adding %s: %s to %s") % (parse_dict['key'], \
                        parse_dict['value'], parse_dict['tag']), 4)
                    output_var[parse_dict['tag']][parse_dict['key']] = \
                        parse_dict['value']
                else:
                    raise OverrideParserException, 'Unknown key: %s' % \
                        parse_dict['key']
        self.data = output_var

class OverrideParserException(Exception):
    pass

