import re, commands
from sets import Set
from linda import libchecks, checks
from linda.parser.makefile import MakefileParser

class DebhelperCheck(libchecks.LindaChecker):
    'Check a packages use of debhelper.'
    def init(self):
        self.dh_info = {'build-deps': 0, 'major': 0, 'compat': 0, 'py': 0, \
            'maint-scripts': ['preinst', 'postinst', 'prerm', 'postrm'], \
            'usage': {'self': 0, 'local': 0, 'cdbs': 0}, 'tag': {}, \
            'used_in': {}}
        for type in ('tag', 'used_in'):
            for maint_script in self.dh_info['maint-scripts']:
                self.dh_info[type][maint_script] = 0

    def check_source_2(self):
        self.dh_commands()
        self.build_deps_and_deps()
        self.check_maint_scripts()
    
    def dh_commands(self):
        mfp = MakefileParser('%s/debian/rules' % self.information['dir'])
        if 'DH_COMPAT' in mfp.variables():
            self.dh_info['usage']['self'] = 1
            self.dh_info['compat'] = int(mfp['DH_COMPAT']['data'])
        for include in mfp.includes:
            if re.match('/usr/share/cdbs/[0-9]+/rules/debhelper\.mk', \
                include):
                self.dh_info['usage']['cdbs'] = 1
        commands = Set()
        for target in mfp.targets():
            commands.union_update(Set(mfp[target]['commands']))
        dprint(_("Commands parsed out: %s.") % commands, 2)
        if commands.intersection(['dh_installinit', 'dh_installwm']):
            for i in ('prerm', 'postrm', 'postinst'):
                self.dh_info['used_in'][i] = 1
        if commands.intersection(['dh_installdocs', 'dh_installemacsen', \
            'dh_installinfo']):
            for i in ('prerm', 'postinst'):
                self.dh_info['used_in'][i] = 1
        if commands.intersection(['dh_installmenu', 'dh_installmime', \
            'dh_installmodules', 'dh_installxfonts']):
            for i in ('postrm', 'postinst'):
                self.dh_info['used_in'][i] = 1
        if 'dh_testversion' in commands:
            self.signal_error('uses-dh-testversion')
        if 'dh_python' in commands:
            self.dh_info['py'] = 1
        for y in commands:
            if y.startswith('dh_'):
                self.dh_info['usage']['self'] = 1
            elif y.startswith('./dh_'):
                self.dh_info['usage']['local'] = 1
    def build_deps_and_deps(self):
        if not self.dh_info['compat']:
            try:
                f = open('%s/debian/compat' % self.information['dir'])
                self.dh_info['compat'] = int(f.readline()[:-1])
                f.close()
            except (IOError, ValueError):
                dprint(_("Can't convert debian/compat."))
        build_deps_python = 0
        for x in ('build-depends', 'build-depends-indep'):
            if self.information['control']['self'][0].has_key(x):
                if self.information['control']['self'][0][x].has_key('debhelper'):
                    self.dh_info['build-deps'] = 1
                    for version in self.information['control']['self'][0][x]['debhelper']['relation']:
                        if version != [None, None]:
                            self.dh_info['major'] = int(version[1].split('.')[0])
                        else:
                            self.dh_info['major'] = 1
                if self.information['control']['self'][0][x].has_key('python'):
                    build_deps_python = 1
                elif self.information['control']['self'][0][x].has_key('python-dev'):
                    build_deps_python = 1
        if not build_deps_python and self.dh_info['py']:
            self.signal_error('no-build-dep-python')
        if self.information['control']['self'][0].has_key('build-depends') or \
            self.information['control']['self'][0].has_key('build-depends-indep'):
            if (self.dh_info['compat'] > self.dh_info['major'] and \
                self.dh_info['compat'] > 1) and not \
                self.dh_info['usage']['local']:
                self.signal_error('dh-compat-greater-than-depends')
        if self.dh_info['build-deps'] and not \
            self.dh_info['usage']['self'] and not \
            self.dh_info['usage']['cdbs']:
            self.signal_error('no-debhelper-but-build-dep')
        elif not self.dh_info['build-deps'] and \
            self.dh_info['usage']['self'] and not \
            self.dh_info['usage']['local']:
            self.signal_error('missing-build-dep-on-dh')
    def check_maint_scripts(self):
        for y in self.dh_info['maint-scripts']:
            try:
                f = open('%s/debian/%s' % (self.information['dir'], y))
                for m in f:
                    if m.find('#DEBHELPER#') != -1:
                        self.dh_info['tag'][y] = 1
                f.close()
            except IOError, e:
                self.dh_info['tag'][y] = -1
        for y in self.dh_info['maint-scripts']:
            if self.dh_info['used_in'][y] and not self.dh_info['tag'][y]:
                self.signal_error('maint-uses-dh-no-tag', [y])    

checks.register(DebhelperCheck)

