//
//
// Copyright 2002 Rob Tougher <robt@robtougher.com>
//
// This file is part of xmlrpc.
//
// xmlrpc is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// xmlrpc is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with xmlrpc; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//


// Implementation of the server_socket class

#include "server_socket.hpp"
#include "socket_exceptions.hpp"

namespace sockets
{

  server_socket::server_socket ( int port )
  {
    if ( ! socket::create() )
      {
	throw socket_exception ( "Could not create server socket." );
      }

    if ( ! socket::bind ( port ) )
      {
	throw socket_exception ( "Could not bind to port." );
      }

    if ( ! socket::listen() )
      {
	throw socket_exception ( "Could not listen to socket." );
      }

  }

  server_socket::~server_socket()
  {
  }


  const server_socket& server_socket::operator << ( const std::string& s ) const
  {
    if ( ! socket::send ( s ) )
      {
	throw socket_exception ( "Could not write to socket." );
      }

    return *this;

  }


  const server_socket& server_socket::operator >> ( std::string& s ) const
  {
    if ( ! socket::recv ( s ) )
      {
	throw socket_exception ( "Could not read from socket." );
      }

    return *this;
  }

  void server_socket::accept ( server_socket& sock ) const
  {
    if ( ! socket::accept ( sock ) )
      {
	throw socket_exception ( "Could not accept socket." );
      }
  }


};
