/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KXSTITCH_H
#define KXSTITCH_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <kurl.h>
#include "schememanager.h"
#include "stitch.h"

class KXStitchDoc;
class KXStitchView;

/** Subclassed KApplication to provide a global floss scheme
    manager, that would be available to all instances of the application.
    @author Stephen Allewell
  */
class KXStitchApplication : public KApplication, public SchemeManager
{
public:
  KXStitchApplication();
};

/** The base class for KXStitch application windows. It sets up the main
    window and reads the config file as well as providing a menubar, toolbar
    and statusbar. An instance of KXStitchView creates your center view, which is connected
    to the window's Doc object.
    KXStitchApp reimplements the methods that KMainWindow provides for main window handling and supports
    full session management as well as using KActions.
    @see KMainWindow
    @see KApplication
    @see KConfig
    @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
    @version KDevelop version 1.2 code generation
  */
class KXStitchApp : public KMainWindow
{
  Q_OBJECT
public:
/** Construtor of KXStitchApp, calls all init functions to create the application.
    @param parent pointer to the parent QWidget
    @param name the internal name of the Object
  */
  KXStitchApp(QWidget* parent=0, const char* name=0);
/** Destructor
  */
  virtual ~KXStitchApp();
/** opens a file specified by commandline option
    @param url the @ref KURL url of the file
  */
  void openDocumentFile(const KURL& url=KURL());
/** returns a pointer to the current document connected to the KTMainWindow instance and is used by
    the View class to access the document object's methods
    @return Pointer to the @ref KXStitchDoc object
  */
  KXStitchDoc *getDocument() const;

public slots:
/** open a new application window by creating a new instance of KXStitchApp
  */
  void slotFileNewWindow();
/** clears the document in the actual view to reuse it as the new document
  */
  void slotFileNew();
/** open a file and load it into the document
  */
  void slotFileOpen();
/** opens a file from the recent files menu
  */
  void slotFileOpenRecent(const KURL& url);
/** save a document
  */
  void slotFileSave();
/** save a document by a new filename
  */
  void slotFileSaveAs();
/** asks for saving if the file is modified, then closes the actual file and window
  */
  void slotFileClose();
/** print the actual file
  */
  void slotFilePrint();
/** add a background image to the editor view
  */
  void slotBackgroundImage();
/** clear the background image
  */
  void slotClearBackgroundImage();
/** modify / view the properties of the current document
  */
  void slotFileProperties();
/** configure KXStitch
  */
  void slotSettingsConfigure();
/** import an image file
  */
  void slotFileImport();
/** scan an image
  */
  void slotFileScan();
/** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
    If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
  */
  void slotFileQuit();
/** toggles the toolbar
  */
  void slotViewToolBar();
/** toggles the stitch toolbar
  */
  void slotViewStitchBar();
/** toggles the tool toolbar
  */
  void slotViewToolToolBar();
/** toggles the statusbar
  */
  void slotViewStatusBar();
/** changes the statusbar contents for the standard label permanently, used to indicate current actions.
    @param text the text that is displayed in the statusbar
  */
  void slotStatusMsg(const QString &text);
/** change the location / size display
  */
  void slotLocationOrSize(QPoint location);
/** change the scale format text
  */
  void slotScaleFormat(QString format);
/** called when the status bar is clicked
  */
  void slotStatusBarClicked(int item);
/** change the status of the stitch mask
  */
  void slotStitchMask(bool enable);
/** change the status of the color mask
  */
  void slotColorMask(bool enable);
/** calibrate the colors
  */
  void slotCalibrate();

protected:
/** save general Options like all bar positions and status as well as the geometry and the
  * recent file list to the configuration file */
  void saveOptions();
/** read general Options again and initialize all variables like the recent file list
  */
  void readOptions();
/** initializes the KActions of the application
  */
  void initActions();
/** sets up the statusbar for the main window by initialzing a statuslabel.
  */
  void initStatusBar();
/** initializes the document object of the main window that is connected to the view in initView().
  * @see initView();
  */
  void initDocument();
/** creates the centerwidget of the KTMainWindow instance and sets it as the view
  */
  void initView();
/** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
    default implementation (only returns true), this calles saveModified() on the document
    object to ask if the document shall be saved if Modified; on cancel the closeEvent is rejected.
    @see KTMainWindow#queryClose
    @see KTMainWindow#closeEvent
  */
  virtual bool queryClose();
/** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
    Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's
    properties.
    @see KTMainWindow#queryExit
    @see KTMainWindow#closeEvent
  */
  virtual bool queryExit();
/** saves the window properties for each open window during session end to the session config file, including saving the currently
    opened file by a temporary filename provided by KApplication.
    @see KTMainWindow#saveProperties
  */
  virtual void saveProperties(KConfig *_cfg);
/** reads the session config file and restores the application's state including the last opened files and documents by reading the
    temporary files saved by saveProperties()
    @see KTMainWindow#readProperties
  */
  virtual void readProperties(KConfig *_cfg);
/** repaint the child widgets
  */
  void repaint();

private:
  KConfig*            m_config;
  KXStitchView*       m_view;
  KXStitchDoc*        m_doc;
  KRecentFilesAction* m_fileOpenRecent;
  KToggleAction*      m_viewToolBar;
  KToggleAction*      m_viewStatusBar;
  KToggleAction*      m_viewStitchBar;
  KToggleAction*      m_viewToolToolBar;
};

#endif // XSTITCH_H
