/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qpainter.h>
#include <qnamespace.h>
#include <klocale.h>
#include "flosslistboxitem.h"

FlossListBoxItem::FlossListBoxItem(QListBox* listBox,Floss* f)
  : QListBoxItem(listBox),
    floss(f),
    m_calibrated(false)
{
}

FlossListBoxItem::~FlossListBoxItem()
{
  // nothing to do
}

int FlossListBoxItem::height(const QListBox *) const
{
  return 20;
}

int FlossListBoxItem::width(const QListBox *) const
{
  return 100;
}

void FlossListBoxItem::paint(QPainter *p)
{
/** draws the list box item as a block of the color followed by the color code and description
  */
  QPen pen = p->pen();

  p->fillRect(0,0,50,18,QBrush(floss->color));
  if (!isSelectable())
    p->setPen(Qt::lightGray);
  QString s = QString("%1 %2 %3").arg(floss->name).arg(floss->description).arg(m_calibrated?i18n("(Calibrated)"):"");
  p->drawText(55,16,s);
  p->setPen(pen);
}

void FlossListBoxItem::setCalibrated(bool c)
{
  m_calibrated = c;
  listBox()->triggerUpdate(false);
}

bool FlossListBoxItem::isCalibrated()
{
  return m_calibrated;
}
