/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __ADDCOLORDIALOG_H
#define __ADDCOLORDIALOG_H

#include <qstring.h>
#include <qptrlist.h>
#include "addcolordlg.h"
#include "floss.h"

/** Wrapper class to manage the picking of floss colors
    and the creation of new colors on the fly
    @author Stephen P Allewell
  */
class AddColorDialog : public AddColorDlg
{
  Q_OBJECT
public:
  AddColorDialog(QWidget* parent, QString schemeName);
  virtual ~AddColorDialog();

protected slots:
  virtual void accept();
  virtual void reject();
  void slotContextHelp();
  void slotNewColor();

private:
  QString         m_schemeName;
  QPtrList<Floss> m_addedColors;
};

#endif
