/***************************************************************************
                          kxe_viewelement.h  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXE_VIEWELEMENT_H
#define KXE_VIEWELEMENT_H

#include <qsplitter.h>

#include <qdom.h>

// forward declarations
class KXE_ViewAttributes;
class KTextEdit;
class KConfig;
class KXESyntaxHighlighter;


/**
 * This widget shows a table of XML elements attributes
 * and plain XML text of this element and its children.
 *
 * @short Widget for XML elements.
 */
class KXE_ViewElement : public QSplitter
{
		Q_OBJECT

	public:

		KXE_ViewElement( QWidget * pParent, KConfig *pConfig, const char * pszName = 0 );
		~KXE_ViewElement();

		/** Returns a pointer to the currently selected attribute or a null pointer. */
		QDomAttr getSelectedAttribute() const;

		/** Changes the behaviour of this view to readonly or readwrite. */
		void setReadWrite( bool fReadWrite );

	public slots:

		/** Changes/Rebuilds the whole widget according to the given element. */
		void slotChange( const QDomElement & );

		/**
		 * Changes syntax highlighting colors.
		 */
		void slotTextViewSettingsChanged();

	protected:

		/** table widget to display XML attributes */
		KXE_ViewAttributes * m_pViewAttributes;
		/** edit widget for plain XML */
		KTextEdit * m_pViewPlainXML;

		/** configuration used to store splitter sizes */
		KConfig *m_pConfig;

		/** Syntax highlighter for m_pViewPlainXML */
		KXESyntaxHighlighter *m_pSyntaxHighlighter;

	signals:

		/** Emitted, when a context menu is requested (see @ref KXE_ViewAttributes::sigContextMenuRequested) */
		void sigContextMenuRequested( const QString & szMenuName, const QPoint & pos );

		/**
		 * Emitted, when an attributes name was renamed via inplace editing
		 * (see @ref KXE_ViewAttributes::sigAttributeChangedInplace).
		 */
		void sigAttributeNameChangedInplace( const QDomAttr &, const QString );

    /**
		 * Emitted, when an attributes value was renamed via inplace editing
		 * (see @ref KXE_ViewAttributes::sigAttributeChangedInplace).
		 */
		void sigAttributeValueChangedInplace( const QDomAttr &, const QString );
};

#endif
