/***************************************************************************
                          options.h  -  description
                             -------------------
    begin                : Sam Nov 23 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPTIONS_H
#define OPTIONS_H

#include <qobject.h>
#include <qstring.h>
#include <klocale.h>
#include <kglobal.h>
#include <kconfig.h>

/**to store/load the options
  *@author Matthias Reif
  */

class Options : public QObject
{
  Q_OBJECT
public: 
	Options();
	~Options();
  /** returns the polling-time */
  int getPolling();
  /** returns the used device */
  QString* getDevice();
  /** returns the string shown when the device is not a wavelan device */
  QString* getNotString();
  /** sets the string shown when the device is not a wavelan device */
  bool setNotString(QString value);
	/** returns the dir. where the icons, .. are located */
  QString* getKwcDir();
  /** restores device and polling time */
  void loadOptions();
  /** saves the device */
  void saveDevice(QString sDevice);
  /** saves the polling time */
  void savePolling(int value);
  /** returns the saved position of the "only link" widget */
  void getSmallPos(int &x, int &y);
  /** saves the position of the "only link" widget */
  void saveSmallPos(int x, int y);

protected:
  QString   *device;			// the actual device
  int       polling;			// the actual polling time
  QString   *kwcDir;			// the dir. where the icons,... are located
  QString   *notString;		// the string when the device is no wlan device
  
signals: // Signals
  /** when polling interval has been changed */
  void pollingChanged(int value);
public slots: // Public slots
  /** when the polling time was changed */
  void slotPolling(int value);
};

#endif
