/***************************************************************************
                          kwcentryedit.cpp  -  description
                             -------------------
    begin                : Sam Feb 1 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwcentryedit.h"

KWCEntryEdit::KWCEntryEdit(const QString & inscr, int row, QWidget *parent, const char *name ) : KWCEntry(inscr, row, parent,name)
{
	valueEdit = new KLineEdit(this);
	valueEdit->setGeometry(*rightWidgetRect);
	valueEdit->show();

	setValueWidget(valueEdit);	
	
	connect(valueEdit, SIGNAL(textChanged(const QString &)), this, SLOT(changedSlot(const QString &)));
}

KWCEntryEdit::~KWCEntryEdit(){
}

/** No descriptions */
void KWCEntryEdit::setValue(const QString & value)
{
	valueEdit->setText(value);
}

/** No descriptions */
void KWCEntryEdit::changedSlot(const QString & text)
{
	changed(text);
}

/** No descriptions */
QString KWCEntryEdit::getText()
{
	return valueEdit->text();
}
