/***************************************************************************
*   Copyright (C) 2003 by Martin Galpin                                   *
*   martin@nemohackers.org                                                *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

/* 
Kuake Main Window. Embeds the KPart konsole and handles all window 
operations. 
For documentated functions see definition - kuake.cpp
*/

#ifndef _KUAKE_H_
#define _KUAKE_H_

#ifdef HAVE_CONFIG_H
    #include <config.h>
#endif

#include <kapplication.h>
#include <kparts/mainwindow.h>
#include "kuakeiface.h"

#define _BUTTON_SIZE 10
#define _ALIGN_TOP 0
#define _ALIGN_BOTTOM 1
#define _ALIGN_LEFT 2
#define _ALIGN_RIGHT 3
#define _SIZE_RATIO_FULL	100
#define _SIZE_RATIO_HALF	50
#define _SIZE_RATIO_THIRD	33
#define _SIZE_RATIO_QUARTER	25
#define _SIZE_RATIO_MIN		10	// Smaller than 10% of the screen doesn't make sense.
#define _ANIMATION_NONE		1
#define _ANIMATION_SLOW		100
#define _ANIMATION_MEDIUM	50
#define _ANIMATION_FAST		10


class QWidgetStack;
class QString;
class KuakePushButton;
class KActionCollection;
class KLibFactory;
class KPopupMenu;
class KGlobalAccel;
class KWinModule;

class Kuake : public KParts::MainWindow, virtual public KuakeIface
{
    Q_OBJECT
public:
    Kuake();
    virtual ~Kuake();
    
    virtual void setKuakeState(int i);
    
    KPopupMenu* ctx;
protected:
    virtual void windowActivationChange(bool oldActive);
    void readConfig();
    void resizeKuake();
    void resizeKeepingState();
    void changeState(bool);
    
public slots:
    void slotChangeState();
    void notifySize(int,int) {};
    void changeColumns(int) {};
    void changeTitle(int,const QString&) {};    
    void slotDestroyed();
    
    void slotAbout();
    void slotQuit();
    
    void slotSizeRatioFull();
    void slotSizeRatioHalf();
    void slotSizeRatioThird();
    void slotSizeRatioQuarter();
    void slotSizeRatioCustom();
    
    void slotCustomSizeOkClicked();
    
    void slotAlignmentTop();
    void slotAlignmentBottom();
    void slotAlignmentRight();
    void slotAlignmentLeft();
    
    void slotToggleKey();
    void slotToggleKeyDialog();
    void slotToggleButton();
    
    void slotAnimationNone();
    void slotAnimationSlow();
    void slotAnimationMedium();
    void slotAnimationFast();
    
private:
    unsigned int screenWidth, screenHeight;
    unsigned int sizeRatio;	// if 0 use pixel value stored in size
    unsigned int size;
    unsigned int alignment;
    bool compact;
    bool activeWindow;
    bool toggleButton;
    WId oldActiveWindow;        // WId of the window that was active
                                // before hotkeying into kuake, 0 otherwise
    KWinModule* kwinmodule;	// need to find out the above
    
    unsigned int ctxSizeRatioFullID;
    unsigned int ctxSizeRatioHalfID;
    unsigned int ctxSizeRatioThirdID;
    unsigned int ctxSizeRatioQuarterID;
    unsigned int ctxSizeRatioCustomID;
    unsigned int ctxSizeRatioCheckedID;
    unsigned int ctxSizeCheckedID;
    unsigned int ctxAlignmentTopID;
    unsigned int ctxAlignmentBottomID;
    unsigned int ctxAlignmentRightID;
    unsigned int ctxAlignmentLeftID;
    unsigned int ctxAlignmentCheckedID;
    unsigned int ctxAnimationNoneID;
    unsigned int ctxAnimationSlowID;
    unsigned int ctxAnimationMediumID;
    unsigned int ctxAnimationFastID;
    unsigned int ctxAnimationCheckedID;
    //unsigned int ctxEnableTabsID;
    unsigned int ctxToggleButtonID;
    
                            
    KParts::ReadOnlyPart* part;
    
    QWidgetStack* stack;
    KuakePushButton* pbResize;
    
    KActionCollection* actionCollection;
    KGlobalAccel* globalAccel;
    
    KPopupMenu* ctxSizeRatio;
    KPopupMenu* ctxAlignment;
    KPopupMenu* ctxAnimation;
    
    void setSizeRatio(int, int);
    void setAlignment(int, int);
    void setAnimation(int, int);
    int animate(int, int, int, int);
    int animation_steps;
    
    int calcSize();
};

#endif // _KUAKE_H_
