/***************************************************************************
                              plotdefines.h
                             ---------------
    begin                : Oct 18, 2004
    copyright            : (C) 2004 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLOTDEFINES_H
#define PLOTDEFINES_H

#include <qstringlist.h>
#include <klocale.h>

#ifndef I18N_NOOP2
#define I18N_NOOP2( comment,x ) x
#endif

enum KstXAxisInterpretation { X_AXIS_INTERP_YEAR,
  X_AXIS_INTERP_CTIME,
  X_AXIS_INTERP_JD,
  X_AXIS_INTERP_MJD,
  X_AXIS_INTERP_RJD,
  X_AXIS_INTERP_AIT };

enum KstXAxisDisplay { X_AXIS_DISPLAY_YEAR,
  X_AXIS_DISPLAY_YYMMDDHHMMSS_SS,
  X_AXIS_DISPLAY_DDMMYYHHMMSS_SS,
  X_AXIS_DISPLAY_QTTEXTDATEHHMMSS_SS,
  X_AXIS_DISPLAY_QTLOCALDATEHHMMSS_SS,
  X_AXIS_DISPLAY_JD,
  X_AXIS_DISPLAY_MJD,
  X_AXIS_DISPLAY_RJD };

struct XAxisInterpretation {
  const char *label;
  KstXAxisInterpretation type;
};

struct XAxisDisplay {
  const char *label;
  KstXAxisDisplay type;
};

const XAxisInterpretation XAxisInterpretations[] = {
  { I18N_NOOP("Julian Year"), X_AXIS_INTERP_YEAR },
  { I18N_NOOP("Standard C time"), X_AXIS_INTERP_CTIME },
  { I18N_NOOP2("Julian Date", "JD"), X_AXIS_INTERP_JD },
  { I18N_NOOP2("Modified Julian Date", "MJD"), X_AXIS_INTERP_MJD },
  { I18N_NOOP2("Reduced Julian Date", "RJD"), X_AXIS_INTERP_RJD },
  { I18N_NOOP2("Time format specific to Planck project", "AIT (Planck)"), X_AXIS_INTERP_AIT }
};          

const XAxisDisplay XAxisDisplays[] = {
  { I18N_NOOP("Julian Year"), X_AXIS_DISPLAY_YEAR },
  { I18N_NOOP("YYYY/MM/DD HH:MM:SS.SS"), X_AXIS_DISPLAY_YYMMDDHHMMSS_SS },
  { I18N_NOOP("DD/MM/YYYY HH:MM:SS.SS"), X_AXIS_DISPLAY_DDMMYYHHMMSS_SS },
  { I18N_NOOP("<Qt Text Date> HH:MM:SS.SS"), X_AXIS_DISPLAY_QTTEXTDATEHHMMSS_SS },
  { I18N_NOOP("<Qt Local Date> HH:MM:SS.SS"), X_AXIS_DISPLAY_QTLOCALDATEHHMMSS_SS },
  { I18N_NOOP2("Julian Date", "JD"), X_AXIS_DISPLAY_JD },
  { I18N_NOOP2("Modified Julian Date", "MJD"), X_AXIS_DISPLAY_MJD },
  { I18N_NOOP2("Reduced Julian Date", "RJD"), X_AXIS_DISPLAY_RJD }
};

typedef struct TickParameters {
  double org;
  double tick;
  bool delta;
  double maxWidth;
  double maxHeight;
  QStringList labels;
  int iHi;
  int iLo;
} TickParameters;

const unsigned int numXAxisInterpretations = sizeof( XAxisInterpretations ) / sizeof( XAxisInterpretation );
const unsigned int numXAxisDisplays = sizeof( XAxisDisplays ) / sizeof( XAxisDisplay );

#endif
