/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include "kstvectordefaults.h"
#include "kst.h"

void KstDataRange::init()
{
  update();
}

void KstDataRange::clickedCountFromEnd()
{
  if (CountFromEnd->isChecked()) {
    N->setEnabled( true );
    F0->setEnabled( false );
    ReadToEnd->setChecked( false );
  } else {
    F0->setEnabled( true );
  }
}

void KstDataRange::ClickedReadToEnd()
{
  if (ReadToEnd->isChecked()) {
    F0->setEnabled( true );
    N->setEnabled( false );
    CountFromEnd->setChecked( false );
  } else {
    N->setEnabled( true );
  }
}

void KstDataRange::clickedDoSkip()
{
  if (DoSkip->isChecked()) {
    Skip->setEnabled( true );
    DoFilter->setEnabled( true );
  } else {
    Skip->setEnabled( false );
    DoFilter->setEnabled( false );
  }
}

void KstDataRange::updateEnables() {
  if (DoSkip->isChecked()) {
    Skip->setEnabled( true );
    DoFilter->setEnabled( true );
  } else {
    Skip->setEnabled( false );
    DoFilter->setEnabled( false );
  }

  if (CountFromEnd->isChecked()) {
    N->setEnabled( true );
    F0->setEnabled( false );
    ReadToEnd->setChecked( false );
  } else if (ReadToEnd->isChecked()) {
    F0->setEnabled( true );
    N->setEnabled( false );
  } else {
    N->setEnabled( true );
    F0->setEnabled( true );
  }

}

void KstDataRange::update()
{
  CountFromEnd->setChecked(KST::vectorDefaults.countFromEOF());
  ReadToEnd->setChecked(KST::vectorDefaults.readToEOF());
  F0->setValue(KST::vectorDefaults.f0());
  N->setValue(KST::vectorDefaults.n());
  Skip->setValue(KST::vectorDefaults.skip());
  DoSkip->setChecked(KST::vectorDefaults.doSkip());
  DoFilter->setChecked(KST::vectorDefaults.doAve());

  clickedCountFromEnd();
  ClickedReadToEnd();
  clickedDoSkip();
}
