/***************************************************************************
                          kpsk.cpp  -  description
                             -------------------
    begin                : Son Jul  2 14:14:12 CEST 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kaboutdialog.h>
#include <kaboutapplication.h>
#include <kconfig.h>
#include <klocale.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <khelpmenu.h>
#include <kiconloader.h>
#include <qaccel.h>
#include <qstring.h>
#include <qtimer.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qpopupmenu.h>
#include <kmenubar.h>
#include <klineeditdlg.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "mainview.h"
#include "kpsk.h"

#include "server/server.h"
#include "logsearch.h"
#include "globals.h"
#include "autocqdlg.h"
#include "dcddlg.h"
#include "fixtextdlg.h"
#include "personalsdlg.h"
#include "devicesdlg.h"
#include "appearencedlg.h"
#include "banddlg.h"
#include "mystatusbar.h"
#include "autocallchexdlg.h"
#include "kpskmeter.h"

s_config config;

/** Our Main Window */

int OPTnew;

Kpsk::Kpsk() : KMainWindow()
{
	bool cancelButton;
  setCaption (i18n ("Main Channel"));
	readConfig();
	
/* Init the PSK31 Server */
	
  while (startServer()) {
		cancelButton=false;
		KMessageBox::error (0, i18n ("Unable to open the audio device!"));
		devicesDlg* dlg = new devicesDlg (this, false, &cancelButton);
		dlg->exec();
		if (cancelButton == true) {
			QTimer::singleShot (0, this, SLOT(close()));
			return;
			}
  }

	commControl (COMM_TXCH, COMM_FREQ, config.psk31.centerFreq * 100);
	commControl (COMM_RXCH, COMM_FREQ, config.psk31.centerFreq * 100);
	commControl (COMM_RXCH, COMM_DCDLEVEL, config.psk31.dcdLevel);
	commControl (COMM_RXCH, COMM_AFC, config.psk31.afc);

	OPTnew=1;	/* Use the old and proven algorithms! */

	initStatusBar();
	view = new mainView (this);
	setCentralWidget (view);
	initMenu();
	/* Display the QSO Info it was displayed in the last session */

	if (config.logbook.qsoinfo)
		QTimer::singleShot (0, this, SLOT(slotShowQSOInfo()));

  resize (config.screen.size);
	view->splitter->setSizes (config.screen.splitter);

	/* These Values will not be changed automatically, so we alter them here */
  if (config.psk31.net == true)
		statusBar()->changeItem (i18n ("NET On"), STATUS_NET);
	else	
    statusBar()->changeItem ("NET Off", STATUS_NET);
	if (config.psk31.cwid == true)
		statusBar()->changeItem (i18n ("CW-ID On"), STATUS_CWID);
	else
		statusBar()->changeItem ("CW-ID Off", STATUS_CWID);

  dcdDialog=NULL;
}

Kpsk::~Kpsk()
{
	if (server_active)
		writeConfig();
}

void Kpsk::readConfig ()
{
	int i;
	char c[3];
	c[1] = '\0';
	QSize* defaultSize = new QSize (815,475);
	QFont* defaultFont = new QFont ("courier", 12, QFont::Normal);

	/* Initialize the config.band structure */

	config.band.band[0] = "160m";
	config.band.band[1] = "80m";
	config.band.band[2] = "40m";
	config.band.band[3] = "30m";
	config.band.band[4] = "20m";
	config.band.band[5] = "17m";
	config.band.band[6] = "15m";
	config.band.band[7] = "12m";
	config.band.band[8] = "10m";
	config.band.band[9] = "2m";
	config.band.band[10] = "70cm";
	config.band.band[11] = "23cm";

	KConfig* kconfig;
	kconfig = KGlobal::config();
	kconfig->setGroup ("PSK31");
	config.psk31.audioDevice = kconfig->readEntry ("audiodevice", "/dev/audio");
	config.psk31.pttDevice = kconfig->readEntry ("pttdevice", "");
	config.psk31.centerFreq = kconfig->readNumEntry ("centerfreq", 1000);
  config.psk31.freq1 = kconfig->readNumEntry ("freq1", 1100);
	config.psk31.dcdLevel = kconfig->readNumEntry ("dcdlevel", 13);
	config.psk31.net = kconfig->readBoolEntry ("net", true);
	config.psk31.afc = kconfig->readBoolEntry ("afc", true);
	config.psk31.cwid = kconfig->readBoolEntry ("cwid", false);

	kconfig->setGroup ("Logbook");
	config.logbook.band = kconfig->readNumEntry ("Band", 4);
 	config.logbook.callchex = kconfig->readBoolEntry ("callchex");  //ernie
  config.logbook.qsoinfo = kconfig->readBoolEntry ("Qsoinfo", false);

	kconfig->setGroup ("Screen");
	config.screen.size = kconfig->readSizeEntry ("size", defaultSize);
  config.screen.splitter = kconfig->readIntListEntry ("splitter");
	if (config.screen.splitter.count() != 3) {
		config.screen.splitter <<175 <<60 <<80;
		}


	kconfig->setGroup ("Fonts");
	config.screen.txwinfont = kconfig->readFontEntry ("txwinfont", defaultFont);
	config.screen.rxwinfont = kconfig->readFontEntry ("rxwinfont", defaultFont);

	kconfig->setGroup ("Fixtexts");
	for (i=0;i<12;++i) {
		sprintf (c, "%i", i);
		config.fixtext.label[i] = kconfig->readEntry (QString ("label") + QString (c), "");
		QFile f (locateLocal("appdata", QString ("fixtext") + QString (c)));
		if ( f.open(IO_ReadOnly) ) {
			QTextStream t (&f);
	    config.fixtext.text[i] = t.read();
			f.close();
			}
		else
			config.fixtext.text[i] = "";
  	}

	kconfig->setGroup ("Personals");
	config.personals.call = kconfig->readEntry ("call", "");
	config.personals.name = kconfig->readEntry ("name", "");
	config.personals.qth = kconfig->readEntry ("qth", "");
	config.personals.loc = kconfig->readEntry ("loc", "");

  kconfig->setGroup ("rxwincolor");
	config.rxwincolor.rx = kconfig->readColorEntry ("rx", &Qt::black);
  config.rxwincolor.tx = kconfig->readColorEntry ("tx", &Qt::red);

  kconfig->setGroup ("bkground");
  config.bkground.rxb = kconfig -> readColorEntry("rxb", &Qt::white);
  config.bkground.txb = kconfig -> readColorEntry ("txb", &Qt::white);
  
  kconfig->setGroup ("h2oColor");
  config.h2oColor.color_water = kconfig->readBoolEntry("color_water", false);
  config.h2oColor.zero = kconfig->readColorEntry ("zero", &Qt::black);
  config.h2oColor.vlow = kconfig->readColorEntry ("vlow", &Qt::darkBlue);
  config.h2oColor.low = kconfig->readColorEntry ("low", &Qt::blue);
  config.h2oColor.mid = kconfig->readColorEntry ("mid", &Qt::darkYellow);
  config.h2oColor.hmid = kconfig->readColorEntry ("hmid", &Qt::yellow);
  config.h2oColor.high = kconfig->readColorEntry ("high", &Qt::yellow);
  config.h2oColor.vhigh = kconfig->readColorEntry ("vhigh", &Qt::red);

	for (i=0;i<12;++i) {
		kconfig->setGroup (config.band.band[i]);
		config.band.offset[i] = kconfig->readDoubleNumEntry ("offset", 0.0);
		config.band.lsb[i] = kconfig->readBoolEntry ("lsb", false);
		}
}

void Kpsk::writeConfig()
{
	int i;
	char c[3];
	c[1] = '\0';
		
	/* Get current modem settings */

	commGetInfo(COMM_RXCH, &rxinfo, sizeof (rxinfo));

	KConfig* kconfig;
	kconfig = KGlobal::config();
	kconfig->setGroup ("PSK31");
	kconfig->writeEntry ("audiodevice", config.psk31.audioDevice);
	kconfig->writeEntry ("pttdevice", config.psk31.pttDevice);

	kconfig->writeEntry ("net", config.psk31.net);
	kconfig->writeEntry ("cwid", config.psk31.cwid);
	kconfig->writeEntry ("afc", (bool) rxinfo.afc);
	kconfig->writeEntry ("lsb", (bool) rxinfo.lsb);
	kconfig->writeEntry ("centerfreq", rxinfo.freq/100);
	kconfig->writeEntry ("dcdlevel", rxinfo.dcdlevel);

	kconfig->setGroup ("Logbook");
  kconfig->writeEntry ("callchex", config.logbook.callchex);     //ernie
  kconfig->writeEntry ("Band", config.logbook.band);
	kconfig->writeEntry ("Qsoinfo", config.logbook.qsoinfo);

	kconfig->setGroup ("Screen");
	kconfig->writeEntry ("size", size());
	kconfig->writeEntry ("splitter", view->splitter->sizes());

	kconfig->setGroup ("Fonts");
	kconfig->writeEntry ("txwinfont", config.screen.txwinfont);
	kconfig->writeEntry ("rxwinfont", config.screen.rxwinfont);

	kconfig->setGroup ("Fixtexts");
	for (i=0;i<12;++i) {
		sprintf (c, "%i", i);
		kconfig->writeEntry (QString ("label") + QString (c), config.fixtext.label[i]);
			QFile f (locateLocal("appdata", QString ("fixtext") + QString (c)));
			if ( f.open(IO_WriteOnly) ) {
				QTextStream t (&f);
				t << config.fixtext.text[i];
				}
	}

	kconfig->setGroup ("Personals");
	kconfig->writeEntry ("call", config.personals.call);
	kconfig->writeEntry ("name", config.personals.name);
	kconfig->writeEntry ("qth", config.personals.qth);
	kconfig->writeEntry ("loc", config.personals.loc);

  kconfig->setGroup ("bkground");
  kconfig -> writeEntry("rxb", config.bkground.rxb);
  kconfig -> writeEntry ("txb", config.bkground.txb);
  
  kconfig->setGroup ("rxwincolor");
	kconfig->writeEntry ("rx", config.rxwincolor.rx);
  kconfig->writeEntry ("tx", config.rxwincolor.tx);

  kconfig->setGroup ("h2oColor");
  kconfig->writeEntry("color_water",config.h2oColor.color_water);
  kconfig->writeEntry("zero",config.h2oColor.zero);
  kconfig->writeEntry("vlow",config.h2oColor.vlow);
  kconfig->writeEntry("low",config.h2oColor.low);
  kconfig->writeEntry("mid",config.h2oColor.mid);
  kconfig->writeEntry("hmid",config.h2oColor.hmid);
  kconfig->writeEntry("high",config.h2oColor.high);
  kconfig->writeEntry("vhigh",config.h2oColor.vhigh);

	for (i=0;i<12;++i) {
		kconfig->setGroup (config.band.band[i]);
		kconfig->writeEntry ("offset", QString::number(config.band.offset[i], 'f', 2));
		kconfig->writeEntry ("lsb", config.band.lsb[i]);
		}


	kconfig->sync();
}

void Kpsk::initMenu()
{
	/* File Menu */
	QPopupMenu* fileMenu = new QPopupMenu();
	fileMenu->insertItem(i18n("Send &File"), this, SLOT (slotSendFile()),CTRL+Key_O,  MENU_FILE_SEND);
	fileMenu->insertSeparator();
	fileMenu->insertItem(i18n("Send &CQ"), this, SLOT (slotCQ ()), ALT+Key_1, MENU_FILE_CQ);
	fileMenu->insertItem(i18n("&Auto CQ"), this, SLOT (slotAcvtivateAutoCQ ()), ALT+Key_2, MENU_FILE_AUTOCQ);
	fileMenu->insertSeparator();
	fileMenu->insertItem(i18n("&Exit"), this, SLOT (close()), CTRL+Key_X, MENU_FILE_QUIT);
  QObject::connect(fileMenu, SIGNAL(highlighted(int)), SLOT(slotStatusBarItemToggle(int)));

  /* Logbook Menu */

	logMenu = new QPopupMenu();
	logMenu->setCheckable(true);
	
	logMenu->insertItem (i18n ("Save QSO"), logbook, SLOT (append()), CTRL+Key_S, MENU_LOG_SAVE);
	logMenu->insertItem (i18n ("Erase Fields"), logbook, SLOT (clear()), CTRL+Key_E, MENU_LOG_CLEAR);
	logMenu->insertItem (i18n ("Search Entrys"), this, SLOT (slotLogFind()), CTRL+Key_F, MENU_LOG_SEARCH);			
	logMenu->insertItem (i18n ("Display QSO Information"), this, SLOT (slotShowQSOInfo()), CTRL+Key_I, MENU_LOG_QSOINFO);
	logMenu->setItemChecked (MENU_LOG_QSOINFO, false);

  QObject::connect(logMenu, SIGNAL(highlighted(int)), SLOT(slotStatusBarItemToggle(int)));

  /* Configuration Menu */

	QPopupMenu* confMenu = new QPopupMenu();
	confMenu->insertItem (i18n ("Fixedtexts"), this, SLOT (slotSettingsFixtext()), 0, MENU_SETTINGS_FIXTEXT);
	confMenu->insertItem (i18n ("Personals"), this, SLOT (slotSettingsPersonals()), 0, MENU_SETTINGS_PERSONALS);
	confMenu->insertItem (i18n ("Devices"), this, SLOT (slotSettingsDevices()), 0, MENU_SETTINGS_DEVICES);
	confMenu->insertItem (i18n ("Appearance"), this, SLOT (slotSettingsAppearence()), 0, MENU_SETTINGS_APPEARENCE);
	confMenu->insertItem (i18n ("Band/Frequency"), this, SLOT (slotSettingsBand()), 0, MENU_SETTINGS_BAND);
	confMenu->insertItem (i18n ("Auto Call Check"), this, SLOT(slotSettingsAutoCallChex()), 0, MENU_SETTINGS_AUTOCALLCHEX);    //ERNIE
  QObject::connect(confMenu, SIGNAL(highlighted(int)), SLOT(slotStatusBarItemToggle(int)));


 /* Clear Rx Menu */

	QPopupMenu* clr_rxMenu = new QPopupMenu();
	clr_rxMenu->insertItem(i18n("&Main RX"), view, SLOT (slotClrMainRx()));
	clr_rxMenu->insertItem(i18n("Channel &1"), water, SLOT (slotClrCh1Rx()));
	clr_rxMenu->insertItem(i18n("Channel &2"), water, SLOT (slotClrCh2Rx()));
	clr_rxMenu->insertItem(i18n("Channel &3"), water, SLOT (slotClrCh3Rx()));
	QObject::connect(clr_rxMenu, SIGNAL(highlighted(int)), SLOT(slotStatusBarItemToggle(int)));

/* Help Menu */

	QPopupMenu* helpMenu = new QPopupMenu();
  helpMenu->insertItem( /*QIconSet(BarIcon("contents")),*/ i18n("&Contents"), this, SLOT(slotHelp()), 0, MENU_HELP_CONTENTS);
  helpMenu->insertSeparator();
  helpMenu->insertItem( i18n("&About K-PSK..."), this, SLOT(slotAbout()), 0, MENU_HELP_ABOUT);
  QObject::connect(helpMenu, SIGNAL(highlighted(int)), SLOT(slotStatusBarItemToggle(int)));

/* Menu Bar */

	menuBar()->insertItem (i18n ("&File"), fileMenu);
 	menuBar()->insertItem (i18n ("&Logbook"), logMenu);
	menuBar()->insertItem (i18n ("Settings"), confMenu);
  menuBar()->insertItem (i18n ("Clear Rx"), clr_rxMenu);
  menuBar()->insertItem (i18n ("Clear &Tx"), view, SLOT(slotClrTx()));
  menuBar()->insertItem (i18n ("&Help"), helpMenu);


	
/* Call Check Active */

  callCheckBox = new QCheckBox (i18n ("C&all Check active"), this);
	menuBar()->insertItem (callCheckBox);
	QObject::connect (callCheckBox, SIGNAL (toggled(bool)), view, SLOT (slotEnableCallcheck(bool)));
  callCheckBox->setChecked(config.logbook.callchex);
}

void Kpsk::slotLogFind()
{
	bool ok = false;
	QString str = KLineEditDlg::getText (i18n ("Enter Search String"), "", &ok, this);
	if (ok == true) {
	logSearch *search = new logSearch ();
	search->search (str);
	search->show();
	}
}

void Kpsk::initStatusBar()
{
	myStatusBar* bar = ((myStatusBar*)statusBar());
	statusBar()->insertFixedItem(i18n (" IMD: ---dB "), STATUS_IMD, true);
	statusBar()->setItemAlignment (STATUS_IMD, AlignLeft | AlignVCenter);
	statusBar()->insertFixedItem(i18n (" Transmit "), STATUS_TX, true);
	bar->setToolTip (STATUS_TX, i18n ("CTRL-T"));
  statusBar()->insertFixedItem(i18n (" Tune Off "), STATUS_TUNE, true);
  bar->setToolTip (STATUS_TUNE, i18n ("CTRL-U"));
  kpskmeter* sMeter = new kpskmeter(statusBar());
  sMeter -> setChannel(COMM_RXCH);
  statusBar()-> addWidget(sMeter);
  statusBar()->insertFixedItem(i18n (" QPSK "), STATUS_QPSK, true);
	bar->setToolTip (STATUS_QPSK, i18n ("CTRL-Q"));
	statusBar()->insertFixedItem(i18n (" CW-ID Off "), STATUS_CWID, true);
	bar->setToolTip (STATUS_CWID, i18n ("CTRL-C"));
	statusBar()->insertFixedItem(i18n (" AFC Off "), STATUS_AFC, true);
	bar->setToolTip (STATUS_AFC, i18n ("CTRL-A"));
	statusBar()->insertFixedItem(i18n (" NET Off "), STATUS_NET, true);
	bar->setToolTip (STATUS_NET, i18n ("CTRL-N"));
	statusBar()->insertFixedItem(i18n ("99999.999kHz "), STATUS_FREQ, true);
	statusBar()->insertItem("", STATUS_DATE, 0, true);
	statusBar()->insertItem("", STATUS_TIME, 0, true);

	QTimer* timer = new QTimer(this);
	QObject::connect( timer, SIGNAL(timeout()), SLOT(slotUpdateStatusBar()));
  timer->start (150, false);

	QObject::connect (statusBar(), SIGNAL (pressed(int)), this, SLOT (slotStatusBarItemToggle(int)));

  QAccel *a = new QAccel(this);
  a->insertItem (Key_A+CTRL, STATUS_AFC);
	a->insertItem (Key_N+CTRL, STATUS_NET);
	a->insertItem (Key_Q+CTRL, STATUS_QPSK);
	a->insertItem (Key_C+CTRL, STATUS_CWID);
	a->insertItem (Key_T+CTRL, STATUS_TX);
  a->insertItem (Key_U+CTRL, STATUS_TUNE);
  a->insertItem (Key_D+CTRL, STATUS_DCD);

// not really the right place, but works ok
	a->insertItem (Key_Escape, ABORT_TX);
  a->insertItem (Key_Left+CTRL, STATUS_DEC_FREQ);
  a->insertItem (Key_Right+CTRL, STATUS_INC_FREQ);
	QObject::connect (a, SIGNAL (activated(int)), this, SLOT (slotStatusBarItemToggle(int)));
}

void Kpsk::slotUpdateStatusBar()
{
	QString str;
	int imd;
	static QString oldtime;
	static QString olddate;
	static int oldimd=65536;
	static int oldrxfreq=-1;
	static int oldtx=-1;
  static int oldtune=-1;
	static int oldafc=-1;
	static int oldqpsk=-1;
  static int oldband=-1;
  static double oldoffset= -1;
  static int oldlsb=-1;



	str = logbook->getTime();
	if (str != oldtime) {
		oldtime = str;
    statusBar()->changeItem (" "+oldtime+"z ", STATUS_TIME);
	}

	str = logbook->getDate();
	if (str != olddate) {
		olddate = str;
    statusBar()->changeItem (" "+olddate+" ", STATUS_DATE);
	}

	commGetInfo (COMM_RXCH, &rxinfo, sizeof (rxinfo));
  commGetInfo (COMM_TXCH, &txinfo, sizeof (txinfo));
  imd = water->getIMD (COMM_RXCH);

    if ((rxinfo.freq/10) != oldrxfreq || config.logbook.band != oldband || \
        config.band.offset[config.logbook.band] != oldoffset || config.band.lsb[config.logbook.band] != oldlsb)  {
		  oldrxfreq = rxinfo.freq/10;
      oldband = config.logbook.band;
      oldoffset = config.band.offset[config.logbook.band];
      oldlsb = config.band.lsb[config.logbook.band];

        if (config.band.offset[config.logbook.band]){
          if (config.band.lsb[config.logbook.band]){
            statusBar()->changeItem (" "+QString::number ((float) (config.band.offset[config.logbook.band]-(28000-oldrxfreq)/10000.0), 'f', 3) + i18n ("kHz "), STATUS_FREQ);
            }
          else {
            statusBar()->changeItem (" "+QString::number ((float) (config.band.offset[config.logbook.band]+oldrxfreq/10000.0), 'f', 3) + i18n ("kHz "), STATUS_FREQ);
            }
        }

     else{
        statusBar()->changeItem (" "+QString::number ((double) (oldrxfreq/10.0), 'f', 1) + i18n ("Hz "), STATUS_FREQ);
	    }
    }

	if (imd != oldimd) {
		oldimd=imd;
    if (imd > 0)
			statusBar()->changeItem (" IMD: ---dB ", STATUS_IMD);
    else{
      statusBar()->changeItem (" IMD: "+QString::number (imd)+ i18n ("dB "), STATUS_IMD);
      }
}

	if (rxinfo.ptt != oldtx) {
		oldtx = rxinfo.ptt;
		if (oldtx == 1) {
			statusBar()->changeItem (i18n ("Transmit"), STATUS_TX);
// set focus to txwindow on transmit
      view->txwindow->setFocus();
			}
		else {
			statusBar()->changeItem (i18n ("Receive"), STATUS_TX);
// not best place to automatically clear tx window but convenient
      view->txwindow->clear();
      }
  }
  if (txinfo.cw != oldtune) {
		oldtune = txinfo.cw;
		if (oldtune == 2 ) {
			statusBar()->changeItem (i18n ("Tune On"), STATUS_TUNE);
			}
		else {
			statusBar()->changeItem (i18n ("Tune Off"), STATUS_TUNE);
      }
  }
	if (rxinfo.afc != oldafc) {
		oldafc = rxinfo.afc;
		if (oldafc == 1)
			statusBar()->changeItem (i18n ("AFC On"), STATUS_AFC);
		else
			statusBar()->changeItem (i18n ("AFC Off"), STATUS_AFC);
  }

	if (rxinfo.qpsk != oldqpsk) {
		oldqpsk = rxinfo.qpsk;
		if (oldqpsk == 1)
			statusBar()->changeItem ("QPSK", STATUS_QPSK);
		else
			statusBar()->changeItem ("BPSK", STATUS_QPSK);
	}
}

void Kpsk::slotStatusBarItemToggle (int item)
{
	if (item == ABORT_TX)
		slotAbortTX();

  if (item == STATUS_DEC_FREQ)
    water->decrementFreq();

  if (item == STATUS_INC_FREQ)
    water->incrementFreq();

	if (item == STATUS_NET) {
		if (config.psk31.net == 0) {
			config.psk31.net = 1;
			statusBar()->changeItem (i18n ("NET On"), STATUS_NET);
		}
		else {
			config.psk31.net = 0;
			statusBar()->changeItem ("NET Off", STATUS_NET);
		}
	}

	if (item == STATUS_AFC) {
		if (rxinfo.afc ==  0)
			commControl (COMM_RXCH, COMM_AFC, 1);
		else
			commControl (COMM_RXCH, COMM_AFC, 0);
	}

	if (item == STATUS_CWID) {
		if (config.psk31.cwid == 0) {
			config.psk31.cwid = 1;
			statusBar()->changeItem (i18n ("CW-ID On"), STATUS_CWID);
		}
		else {
			config.psk31.cwid = 0;
			statusBar()->changeItem ("CW-ID Off", STATUS_CWID);
		}
	}

	if (item == STATUS_QPSK) {
		if (rxinfo.qpsk ==  0) {
			commControl (COMM_RXCH, COMM_QPSK, 1);
			commControl (COMM_TXCH, COMM_QPSK, 1);
		}
		else {
			commControl (COMM_RXCH, COMM_QPSK, 0);
			commControl (COMM_TXCH, COMM_QPSK, 0);
		}
	}

	if (item == STATUS_TX) {
		if (rxinfo.ptt == 0)
			transmit (true);
		else
			transmit (false);
  }

  if (item == STATUS_TUNE){
    if (txinfo.cw == 0 ){
      commControl (COMM_TXCH, COMM_MODE, MO_TUNE);
      commControl (COMM_TXCH, COMM_PTT, PTTON|PTTFORCE);
      }
    else {
      commControl (COMM_TXCH, COMM_MODE, MO_NORMAL);
      usleep (100000);
      commControl (COMM_TXCH, COMM_PTT, PTTOFF);
      }
  }

  // The short help messages
	// Maybe should we make an own slot for this?

	if (item == MENU_LOG_SAVE)
		statusBar()->message (i18n ("Save the current logbook data."),2000);
	if (item == MENU_LOG_CLEAR)
		statusBar()->message (i18n ("Clear the displayed logbook fields."),2000);
	if (item == MENU_LOG_SEARCH)
		statusBar()->message (i18n ("Find an entry in the logbook."),2000);
	if (item == MENU_LOG_QSOINFO)
		statusBar()->message (i18n ("Displays the QSO information window."),2000);
	
	if (item == MENU_FILE_SEND)
		statusBar()->message (i18n ("Sends a file from the disk."),2000);
	if (item == MENU_FILE_SAVE)
		statusBar()->message (i18n ("Logs the RX text to a file."),2000);
	if (item == MENU_FILE_CQ)
		statusBar()->message (i18n ("Sends a CQ call."), 2000);
	if (item == MENU_FILE_AUTOCQ)
		statusBar()->message (i18n ("Activates the Auto CQ dialog."), 2000);
	if (item == MENU_FILE_QUIT)
		statusBar()->message (i18n ("Terminates the program."), 2000);

	if (item == MENU_SETTINGS_FIXTEXT)
		statusBar()->message (i18n ("Sets the fixedtexts."), 2000);
	if (item == MENU_SETTINGS_PERSONALS)
		statusBar()->message (i18n ("Sets station information."), 2000);
	if (item == MENU_SETTINGS_DEVICES)
		statusBar()->message (i18n ("Sets the devices to use."), 2000);
	if (item == MENU_SETTINGS_APPEARENCE)
		statusBar()->message (i18n ("Sets the appearance of K-PSK."), 2000);
	if (item == MENU_SETTINGS_BAND)
		statusBar()->message (i18n ("Sets frequencies"), 2000);
	if (item == MENU_SETTINGS_SENS)
		statusBar()->message (i18n ("Sets the waterfall sensitivity"), 2000);
	if (item == MENU_SETTINGS_AUTOCALLCHEX)                                                    //ERNIE
		statusBar()->message (i18n ("If enabled, automatically completes call field."), 2000);    //ERNIE
    
  if (item == MENU_HELP_ABOUT)
		statusBar()->message (i18n ("About K-PSK."), 2000);
  if (item == MENU_HELP_CONTENTS)
		statusBar()->message (i18n ("Show help documentation."), 2000);
}

void Kpsk::transmit (bool i)
{
	static bool receive;
	if (i == true) {
		if (config.psk31.net == true)
			commControl (COMM_TXCH, COMM_FREQ, rxinfo.freq);
		commControl (COMM_TXCH, COMM_PTT, PTTON | PTTFORCE);
	  receive = false;
	}
	else {
		if (receive == false) {
			if ((config.psk31.cwid == true) && (config.personals.call.isNull() == false)) {
				char *c = strdup (config.personals.call.latin1());
				commControl (COMM_TXCH, COMM_MODE, MO_CWSEND);
				commPutData (c, strlen (c));
				commControl (COMM_TXCH, COMM_MODE, MO_NORMAL);
				free (c);
			}
			receive = true;
      usleep (100000);            // Workaround for an bug in hansis Classes
			commControl (COMM_TXCH, COMM_PTT, PTTOFF);
		}
      statusBar()->changeItem (i18n ("Flushing"), STATUS_TX);

	}
}

/** Send exactly one automatically generated CQ Text */
void Kpsk::slotCQ()
{
	QString str = "\001CQ CQ CQ de % % %\nCQ CQ CQ de % % %\nCQ CQ CQ de % % %\npse K\n\002";
	str.replace (QRegExp ("%"), config.personals.call);
	transmitText (str);
   	callCheckBox->setChecked(config.logbook.callchex);          //ernie
//	callCheckBox->setChecked(true);       //ernie
}

void Kpsk::slotAcvtivateAutoCQ()
{
	autoCQdlg* autoCQ = new autoCQdlg (this);
	autoCQ->show();
}

void Kpsk::slotSendFile()
{
	QString filename = KFileDialog::getOpenFileName();
	if (filename.isNull()) return;
	QFile f (filename);
		if ( f.open(IO_ReadOnly )) {
			QTextStream t (&f);
			view->txwindow->appendString (t.read(), true);
    	f.close();
		}
	else
		KMessageBox::error (this, i18n ("Unable to open file for reading!"));
}

void Kpsk::slotHelp()
{
	KApplication::kApplication()->invokeHelp ("", "");
}

void Kpsk::slotAbout()
{
	KAboutApplication* about = new KAboutApplication (this);
	about->show();
}


void Kpsk::slotAbortTX()
{
	commControl (COMM_TXCH, COMM_PTT, PTTOFF|PTTFORCE);
}

void Kpsk::transmitText (QString str)
{
	view->transmitText (str);
}

void Kpsk::setTXWinFocus()
{
	view->txwindow->setFocus();
}

void Kpsk::slotSettingsFixtext()
{
	fixtextDlg* dlg = new fixtextDlg (this);
	dlg->show();
}

void Kpsk::reInit()
{
	writeConfig();
  view->reInit();
	water->reInit();
}

void Kpsk::slotSettingsPersonals()
{
	personalsDlg* dlg = new personalsDlg (this);
	dlg->show();
}

void Kpsk::slotSettingsDevices()
{
	devicesDlg* dlg = new devicesDlg (this);
	dlg->show();
}



bool Kpsk::startServer()
{
	char *ptt = strdup (config.psk31.pttDevice.latin1());
	char *aud = strdup (config.psk31.audioDevice.latin1());
  server_active = !server_main (aud, ptt);
	free (ptt);
	free (aud);
	if (!server_active)
		return 1;
	else
		return 0;
}

void Kpsk::slotSettingsAppearence()
{
	appearenceDlg* dlg = new appearenceDlg (this);
	dlg->show();	
}

void Kpsk::slotSettingsBand()
{
	bandDlg* dlg = new bandDlg (this);
	dlg->show();
}

void Kpsk::slotShowQSOInfo()
{
	if (logMenu->isItemChecked (MENU_LOG_QSOINFO)) {
		logbook->showQsoInfo (false);
		logMenu->setItemChecked (MENU_LOG_QSOINFO, false);
		config.logbook.qsoinfo=false;
		}
	else {
		logbook->showQsoInfo (true);
		logMenu->setItemChecked (MENU_LOG_QSOINFO, true);
		config.logbook.qsoinfo=true;
		}		
}

void Kpsk::uncheckQsoInfoMenu()
{
	logMenu->setItemChecked (MENU_LOG_QSOINFO, false);
	config.logbook.qsoinfo=false;
}

void Kpsk::slotSettingsAutoCallChex()
{
	autocallchexDlg* dlg = new autocallchexDlg (this);
	dlg->show();
}
