/* @(#) moduleops.c 1.7 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: MODULE
\***************************************************************/

#define _KOALAMUD_MODULEOPS_C "@(#) nitehawk@localhost.1ststep.net|lib/koalamod/moduleops.c|20000827025249|53798 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "memory.h"
#include "llist.h"
#include "module.h"

/* Setinel definition */
module_t nullmodule =
{
	NULL,
	NULL,
	MODSTATE_UNDEFINED,
	NULL,
	NULL,
	NULL
};

/* Loop through a list of modules and call the startup function for each */
int modstartup(pmodule modlist[], pmodule listend, int *num, int *errors)
{
	int i = 0;
	pmodule cur = modlist[i];
	int err;

	/* Loop until we match the listend */
	while (cur != listend)
	{
		(*num)++;

		/* Call the startup function - should return 0, anything else is
		 * 	an error */
		if ((err = cur->startupfn()) != 0)
		{
			logmsg(LOGERR, "Error #%d starting %s module version %s.",
					err, cur->name, cur->version);
			(*errors)++;
		}
		cur = modlist[++i];
	}

	if (*errors <= *num)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}

/* Loop through a list of modules and call the linkup function for each */
int modlinkup(pmodule modlist[], pmodule listend, int *num, int *errors)
{
	int i = 0;
	pmodule cur = modlist[i];
	int err;

	/* Loop until we match the listend */
	while (cur != listend)
	{
		(*num)++;

		/* Call the startup function - should return 0, anything else is
		 * 	an error */
		if ((err = cur->linkupfn()) != 0)
		{
			logmsg(LOGERR, "Error #%d linking %s module version %s.",
					err, cur->name, cur->version);
			(*errors)++;
		}
		cur = modlist[++i];
	}

	if (*errors <= *num)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}

/* Loop through a list of modules and call the shutdown function for each */
int modshutdown(pmodule modlist[], pmodule listend, int *num, int *errors)
{
	int i = 0;
	pmodule cur = modlist[i];
	int err;

	/* Loop until we match the listend */
	while (cur != listend)
	{
		(*num)++;

		/* Call the startup function - should return 0, anything else is
		 * 	an error */
		if ((err = cur->shutdownfn()) != 0)
		{
			logmsg(LOGERR, "Error #%d stopping %s module version %s.",
					err, cur->name, cur->version);
			(*errors)++;
		}
		cur = modlist[++i];
	}
	
	if (*errors <= *num)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}
