h48201
s 00000/00036/00115
d D 1.16 00/11/04 21:08:15 nitehawk 17 16
c Move do_modlist to modcommands.c in koalamod
cC
cK21094
e
s 00000/00000/00151
d D 1.15 00/11/04 19:31:33 nitehawk 16 15
c Rename: src/client/commandinfo.c -> lib/basecommand/info.c
cC
cK55435
cPlib/basecommand/info.c
e
s 00000/00134/00151
d D 1.14 00/11/04 19:07:46 nitehawk 15 14
c remove defunct command handlers
cC
cK27967
e
s 00134/00004/00151
d D 1.13 00/11/04 18:51:43 nitehawk 14 13
c Clone old command handlers into new prototypes which include
c argument list.
cC
cHwinghove.1ststep.net
cK18923
cZ-08:00
e
s 00002/00000/00153
d D 1.12 00/08/09 21:11:48 nitehawk 13 12
c Fix segfault issue in modlist
cC
cK26660
e
s 00036/00000/00117
d D 1.11 00/08/08 22:03:52 nitehawk 12 11
c ad modlist command
cC
cK24766
e
s 00020/00015/00097
d D 1.10 00/08/08 21:01:19 nitehawk 11 10
c commands now dynamically generates command list.
c commands will be depreciated when full help code is written
cC
cK20055
e
s 00002/00000/00110
d D 1.9 00/08/01 20:39:24 nitehawk 10 9
c Add load and unload to command list
cC
cK06859
e
s 00003/00003/00107
d D 1.8 00/07/30 09:44:22 nitehawk 9 8
c Update commands command
cC
cK01547
e
s 00021/00000/00089
d D 1.7 00/07/30 09:16:12 nitehawk 8 7
c Add commandlist function
cC
cHlocalhost.1ststep.net
cK63935
cZ-07:00
e
s 00000/00000/00089
d D 1.6 00/03/07 11:48:10 nitehawk 7 6
c Turn on SCCS flag
cC
cK47026
cX0xa1
e
s 00000/00000/00089
d D 1.5 00/02/10 09:21:30 nitehawk 6 5
c Rename: src/commandinfo.c -> src/client/commandinfo.c
cC
cK23255
cPsrc/client/commandinfo.c
e
s 00008/00000/00081
d D 1.4 00/02/04 20:37:26 nitehawk 5 4
c Added version command
cC
cK30783
e
s 00063/00000/00018
d D 1.3 00/02/01 10:38:42 nitehawk 4 3
c Basic 'who' command implemented
cC
cK14621
e
s 00001/00001/00017
d D 1.2 00/01/31 09:11:34 nitehawk 3 2
c Forgot to include commands.h
cC
cK32012
e
s 00018/00000/00000
d D 1.1 00/01/31 09:05:19 nitehawk 2 1
cF1
cK30137
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/01/31 09:05:19 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/src/commandinfo.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK28089
cPsrc/commandinfo.c
cRdf0ab71ede61afc3
cV3
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: COMMANDS
\***************************************************************/

#define _KOALAMUD_COMMANDINFO_C "%Z% %K% %Z%"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "network.h"
#include "buffer.h"
D 3

E 3
I 3
#include "commands.h"
I 4
#include "memory.h"
#include "llist.h"
I 12
#include "module.h"
I 14
#include "kparser.h"

/* Command list - Send a list of commands to player */
koalaerror do_commandlist(pdescriptor desc, argument *arglist[])
{
	char buf[256];
	pcommandentry cur = ctablehead;

	/* Queue Header */
	snprintf(buf, 256, "Available Commands:\r\n");
	buffer_queue(desc, buf, strlen(buf));

	/* We are going to dynamically create a list of commands - currently
	 * without usage information */
	while (cur)
	{
		snprintf(buf, 256, " %s\r\n", cur->command);
		buffer_queue(desc, buf, strlen(buf));
		cur = cur->next;
	}
	
	/* Just build a list of commands and queue it */
	return KESUCCESS;
}

/* We make a lot of assumptions in this command:
 * 	All player descriptors in the master list have the character memory
 *	 	allocated
 *	We have been passed a valid descriptor
 */
koalaerror do_who(pdescriptor desc, argument *arglist[])
{
	char buf[120];
	listnodeptr tmplist;
	pdescriptor tmpdesc;
	int numprinted = 0;

	/* Get a pointer to the master descriptor list */
	tmplist = getdescriptorlist();

	/* Send the header */
	snprintf(buf, 120, "The following players are in the realm on your"
			" server:\r\n");
	buffer_queue(desc, buf, strlen(buf));

	/* Loop through the descriptor list */
	while (tmplist)
	{
		tmpdesc = tmplist->data.desc;

		/* Filter on descriptor type */
		if (tmpdesc->type != DESCRIPTOR_PLAYER)
		{
			tmplist = listnextnode(tmplist);
			continue;
		}

		/* Send the name on the current descriptor */
		memset(buf, ' ', 40);
		snprintf(buf, 30, "%s", tmpdesc->data.character->name);
		buffer_queue(desc, buf, 30);

		/* increment numprinted */
		numprinted++;

		/* Print the separator */
		if ((numprinted % 2) == 0)
		{
			buffer_queue(desc, "\r\n", 2);
		}
		else
		{
			buffer_queue(desc, "\t", 1);
		}

		/* Advance to the next node */
		tmplist = listnextnode(tmplist);
	}

	/* Print out a summary line */
	snprintf(buf, 120, "\r\nThere are %d players connected.\r\n", numprinted);
	buffer_queue(desc, buf, strlen(buf));

	return KESUCCESS;
}

/* Version command - Send version string to player */
koalaerror do_version(pdescriptor desc, argument *arglist[])
{
	/* Easy one :) */
	buffer_queue(desc, COPYRIGHTSTR, strlen(COPYRIGHTSTR));
	return KESUCCESS;
}

D 17
/* modlist - Display a list of loaded modules */
koalaerror do_modlist(pdescriptor desc, argument *arglist[])
{
	listnodeptr modlist;
	char buf[256];
	dynmod_t *pmod;

	/* Get a pointer to the loaded module list */
	if ((modlist = getmodlisthead()) == NULL)
	{
		snprintf(buf, 256, "No modules loaded.\r\n");
		buffer_queue(desc, buf, strlen(buf));
		return KESUCCESS;
	}

	/* Display header */
	snprintf(buf, 256,
"Module Name\tFull Name\t\tVersion\r\n"
"-----------\t---------\t\t-------\r\n");
	buffer_queue(desc, buf, strlen(buf));

	/* Cycle through modules and display information */
	while (modlist)
	{
		pmod = (dynmod_t *)modlist->data.generic;
		if (pmod == NULL)
			break;
		snprintf(buf, 256, "%s\t%s\t\t%s\r\n", pmod->modname,
				pmod->module.name, pmod->module.version);
		buffer_queue(desc, buf, strlen(buf));

		modlist = listnextnode(modlist);
	}

	return KESUCCESS;
}
E 17
E 14
E 12
D 15

/* We make a lot of assumptions in this command:
 * 	All player descriptors in the master list have the character memory
 *	 	allocated
 *	We have been passed a valid descriptor
 */
D 14
koalaerror do_who(pdescriptor desc)
E 14
I 14
koalaerror do_oldwho(pdescriptor desc)
E 14
{
	char buf[120];
	listnodeptr tmplist;
	pdescriptor tmpdesc;
	int numprinted = 0;

	/* Get a pointer to the master descriptor list */
	tmplist = getdescriptorlist();

	/* Send the header */
	snprintf(buf, 120, "The following players are in the realm on your"
			" server:\r\n");
	buffer_queue(desc, buf, strlen(buf));

	/* Loop through the descriptor list */
	while (tmplist)
	{
		tmpdesc = tmplist->data.desc;

		/* Filter on descriptor type */
		if (tmpdesc->type != DESCRIPTOR_PLAYER)
		{
			tmplist = listnextnode(tmplist);
			continue;
		}

		/* Send the name on the current descriptor */
		memset(buf, ' ', 40);
		snprintf(buf, 30, "%s", tmpdesc->data.character->name);
		buffer_queue(desc, buf, 30);

		/* increment numprinted */
		numprinted++;

		/* Print the separator */
		if ((numprinted % 2) == 0)
		{
			buffer_queue(desc, "\r\n", 2);
		}
		else
		{
			buffer_queue(desc, "\t", 1);
		}

		/* Advance to the next node */
		tmplist = listnextnode(tmplist);
	}

	/* Print out a summary line */
	snprintf(buf, 120, "\r\nThere are %d players connected.\r\n", numprinted);
	buffer_queue(desc, buf, strlen(buf));

	return KESUCCESS;
}
I 5

/* Version command - Send version string to player */
D 14
koalaerror do_version(pdescriptor desc)
E 14
I 14
koalaerror do_oldversion(pdescriptor desc)
E 14
{
	/* Easy one :) */
	buffer_queue(desc, COPYRIGHTSTR, strlen(COPYRIGHTSTR));
	return KESUCCESS;
}
I 8

/* Command list - Send a list of commands to player */
D 14
koalaerror do_commandlist(pdescriptor desc)
E 14
I 14
koalaerror do_oldcommandlist(pdescriptor desc)
E 14
{
D 11
	char buf[2048];
E 11
I 11
	int alpha;
	int command;
	char buf[256];
E 11

D 11
	/* Just build a list of commands and queue it */
	snprintf(buf, 2048,
			"Available commands:\r\n"
			"commands\r\n"
I 10
			"load [filename.so] [modname]\r\n"
E 10
			"memstat\r\n"
			"quit\r\n"
D 9
			"reboot\r\n"
			"say\r\n"
			"shutdown\r\n"
E 9
I 9
			"reboot [time] [node]\r\n"
			"say <line>\r\n"
			"shutdown [time] [node]\r\n"
I 10
			"unload [modname]\r\n"
E 10
E 9
			"version\r\n"
			"who\r\n"
			"\r\n");
E 11
I 11
	/* Queue Header */
	snprintf(buf, 256, "Available Commands:\r\n");
E 11
	buffer_queue(desc, buf, strlen(buf));
I 11

	/* We are going to dynamically create a list of commands - currently
	 * without usage information */
	for (alpha=0; alpha < 27; alpha++)
	{
		command=0;
		while (commandtable[alpha][command].command)
		{
			snprintf(buf, 256, " %s\r\n", commandtable[alpha][command].command);
			buffer_queue(desc, buf, strlen(buf));
			command++;
		}
	}
	
	/* Just build a list of commands and queue it */
I 12
	return KESUCCESS;
}

/* modlist - Display a list of loaded modules */
D 14
koalaerror do_modlist(pdescriptor desc)
E 14
I 14
koalaerror do_oldmodlist(pdescriptor desc)
E 14
{
	listnodeptr modlist;
	char buf[256];
	dynmod_t *pmod;

	/* Get a pointer to the loaded module list */
	if ((modlist = getmodlisthead()) == NULL)
	{
		snprintf(buf, 256, "No modules loaded.\r\n");
		buffer_queue(desc, buf, strlen(buf));
		return KESUCCESS;
	}

	/* Display header */
	snprintf(buf, 256,
"Module Name\tFull Name\t\tVersion\r\n"
"-----------\t---------\t\t-------\r\n");
	buffer_queue(desc, buf, strlen(buf));

	/* Cycle through modules and display information */
	while (modlist)
	{
		pmod = (dynmod_t *)modlist->data.generic;
I 13
		if (pmod == NULL)
			break;
E 13
		snprintf(buf, 256, "%s\t%s\t\t%s\r\n", pmod->modname,
				pmod->module.name, pmod->module.version);
		buffer_queue(desc, buf, strlen(buf));

		modlist = listnextnode(modlist);
	}

E 12
E 11
	return KESUCCESS;
}
E 15
E 8
E 5
E 4
E 3
E 2
I 1
E 1
