/* @(#) config.h 1.27 @(#) */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: Config
\***************************************************************/

#ifndef _KOALAMUD_CONFIG_H
#define _KOALAMUD_CONFIG_H "@(#) nitehawk@localhost.1ststep.net|include/config.h|20000730062253|18284 @(#)"

/* Database access types
 * 		Each of the following defines enables the respective database type.
 * 		While it is possible to have all database types enabled, it is
 * 		recommended that db types that will definatly not be used should be
 * 		disabled.  This conserves memory needed for the library and is
 * 		(marginally) lessens startup time.
 *
 * 		MYSQL	Enable usage of mysql as a database backend.  Requires mysql
 * 				to be installed and working, and mysql client libraries to be
 * 				available on local system.  Target mysql server host, port,
 * 				username and password are defined in koala.xml.
 *
 * 		KOALA	Enable usage of koaladb for on disk database.  This format
 * 				requires no external apps to be installed.  The database base
 * 				path and root db name are specified in koala.xml.  In
 * 				addition, if there are secondary databases, they can also be
 * 				specified in koala.xml.
 */
#define KOALADB_MYSQL_ENABLE 1	/* Unimplemented */
#define KOALADB_KOALA_ENABLE 1	/* Unimplemented */

/* This string is sent to the player if they send a command that is not
 * recognized */
/* FIXME: This should probably be a run time option */
#define UNKNOWNCOMMANDRESPONSE	"huh?\r\n"

/* Most of the rest of this file should not need touched.  It won't hurt to
 * take a look, however.  Don't change any of the remaining options without
 * understanding what they do, however
 */

#define KEDEFAULTCLIENTPORT 6464
#define KEDEFAULTUPLINKPORT 8204

/* Lengths for host and port strings */
#ifndef MAXHOSTNAMELEN
#ifdef NI_MAXHOST
#define MAXHOSTNAMELEN	NI_MAXHOST
#else
#define MAXHOSTNAMELEN	1025
#endif
#endif
#ifndef PORTSTRLEN
#ifdef NI_MAXSERV
#define PORTSTRLEN	NI_MAXSERV
#else
#define PORTSTRLEN	32
#endif
#endif

/* Number of connections to hold in the listen queue */
#define LISTENBACKQUEUE		10

/* Maximum path length if it isn't defined */
#ifndef PATH_MAX
#define PATH_MAX 1024
#endif

/* Maximum size of an XML message */
#ifndef MAXXMLMSGLEN
#define MAXXMLMSGLEN 8096
#endif

/* Buffer Sizes - We allocate 1 byte more then this value to ensure that we
 * always have a null terminator to work with */
#define OUTRINGSIZE	2047
#define INRINGSIZE	2047

/* Maximum write size - Throttle control to prevent flooding on client */
#define MAXWRITESIZE 512

/* This is the base length for words and the step size for reallocs */
#define WORDLENSTEP	10

/* This is the base length for lines and the step size for reallocs */
#define LINELENSTEP	40

/* This is the maximum time each loop in the daemon should take,
 * currently approximately 1/10th of a second */
#define DEFAULTTICKLEN	100000

/* This is the default number of cycles the daemon loop makes between
 * reporting status */
#define DEFAULTREPORTINGPERIOD 600	// Report every 60 seconds 

/* Base Filename of reboot state file */
#define REBOOTSTATEFILE		"reboot_state"

/* Should we turn on non blocking sockets - Do *NOT* set this to zero unless
 * you understand the implications of forcing non-blocking operations on the
 * network code */
#define GONONBLOCK 1

/* Error Base Points */
#define ERRKOALABASE		0x1000
#define ERRKOALAMODBASE		0x2000
#define ERRKOALAVMBASE		0x3000

#endif
