// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.21 $

#include "hk_kdecsvexportdialog.h"
#include "hk_kdecsvexportdialog.moc"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <vector>
#include <hk_database.h>
#include <kapplication.h>
#include <kconfig.h>

/*
 *  Constructs a hk_kdecsvexportdialog which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
hk_kdecsvexportdialog::hk_kdecsvexportdialog( const QString& table, QWidget* parent,  const char* name, bool modal, WFlags fl )
: QDialog( parent, name, modal, fl )    ,hk_reportcsv()
{
    if ( !name )
        setName( "hk_kdecsvexportdialog" );
    resize( 328, 171 );
    p_tablename=table;
    setCaption( i18n( "CSV export Dialog"  ) );
    setSizeGripEnabled( TRUE );
    setMaximumSize( QSize( 32767, 32767 ) );
    setBackgroundOrigin( QDialog::WidgetOrigin );
    hk_kdecsvexportdialogLayout = new QHBoxLayout( this );
    hk_kdecsvexportdialogLayout->setSpacing( 6 );
    hk_kdecsvexportdialogLayout->setMargin( 11 );

    Layout12 = new QVBoxLayout;
    Layout12->setSpacing( 6 );
    Layout12->setMargin( 0 );

    Layout10 = new QHBoxLayout;
    Layout10->setSpacing( 1 );
    Layout10->setMargin( 0 );

    TextLabel1 = new QLabel( this, "TextLabel1" );
    TextLabel1->setText( i18n( "Filename:"  ) );
    Layout10->addWidget( TextLabel1 );

    filefield = new QLineEdit( this, "filefield" );
    filefield->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)0, filefield->sizePolicy().hasHeightForWidth() ) );
    Layout10->addWidget( filefield );

    filebutton = new QToolButton( this, "filebutton" );
    filebutton->setText(  "..."   );
    Layout10->addWidget( filebutton );
    Layout12->addLayout( Layout10 );

    Layout11 = new QGridLayout;
    Layout11->setSpacing( 6 );
    Layout11->setMargin( 0 );

    tablelist = new QComboBox( this, "tablelist" );

    Layout11->addMultiCellWidget( tablelist, 0, 0, 1, 2 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout11->addItem( spacer, 3, 1 );

    TextLabel3 = new QLabel( this, "TextLabel3" );
    TextLabel3->setText( i18n( "Text delimiter"  ) );
    TextLabel3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel3->sizePolicy().hasHeightForWidth() ) );

    Layout11->addWidget( TextLabel3, 2, 0 );

    firstrow = new QCheckBox( this, "firstrow" );
//    firstrow->setText( i18n( ""  ) );
    firstrow->setChecked( TRUE );

    Layout11->addWidget( firstrow, 3, 2 );

    TextLabel1_3 = new QLabel( this, "TextLabel1_3" );
    TextLabel1_3->setText( i18n( "Field names in first row"  ) );

    Layout11->addWidget( TextLabel1_3, 3, 0 );

    textdelimiterfield = new QLineEdit( this, "textdelimiterfield" );
    textdelimiterfield->setText( "\""   );

    Layout11->addMultiCellWidget( textdelimiterfield, 2, 2, 1, 2 );

    TextLabel1_2 = new QLabel( this, "TextLabel1_2" );
    TextLabel1_2->setText( i18n("Tablename:"  ) );

    Layout11->addWidget( TextLabel1_2, 0, 0 );

    TextLabel2 = new QLabel( this, "TextLabel2" );
    TextLabel2->setText( i18n("Column Separator"  ) );

    Layout11->addWidget( TextLabel2, 1, 0 );
    p_tab=i18n("Tab");
    columnseparatorfield = new QComboBox( FALSE, this, "columnseparatorfield" );
    columnseparatorfield->insertItem( ","  );
    columnseparatorfield->insertItem(  ";"  );
    columnseparatorfield->insertItem( p_tab);
    columnseparatorfield->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, columnseparatorfield->sizePolicy().hasHeightForWidth() ) );

    Layout11->addMultiCellWidget( columnseparatorfield, 1, 1, 1, 2 );
    Layout12->addLayout( Layout11 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Layout12->addItem( spacer_2 );
    hk_kdecsvexportdialogLayout->addLayout( Layout12 );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
    hk_kdecsvexportdialogLayout->addItem( spacer_3 );

    Layout5 = new QVBoxLayout;
    Layout5->setSpacing( 6 );
    Layout5->setMargin( 0 );

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setText( i18n( "&OK"  ) );
    buttonOk->setAutoDefault( TRUE );
    buttonOk->setDefault( TRUE );
    buttonOk->setEnabled( FALSE );
    Layout5->addWidget( buttonOk );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setText( i18n( "&Cancel"  ) );
    buttonCancel->setAutoDefault( TRUE );
    Layout5->addWidget( buttonCancel );

    buttonHelp = new QPushButton( this, "buttonHelp" );
    buttonHelp->setText( i18n( "&Help"  ) );
    buttonHelp->setAutoDefault( TRUE );
    Layout5->addWidget( buttonHelp );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Layout5->addItem( spacer_4 );
    hk_kdecsvexportdialogLayout->addLayout( Layout5 );

// signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( ok_clicked() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( filebutton, SIGNAL( clicked() ), this, SLOT( filebutton_clicked() ) );
    connect( filefield, SIGNAL( textChanged(const QString&) ), this, SLOT( buttons_enabled() ) );
    connect( tablelist, SIGNAL( textChanged(const QString&) ), this, SLOT( buttons_enabled() ) );
    connect( columnseparatorfield, SIGNAL( textChanged(const QString&) ), this, SLOT( buttons_enabled() ) );
    p_datasourcetype=dt_table;
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("CSVExport");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);
}


hk_kdecsvexportdialog::~hk_kdecsvexportdialog()
{
// no need to delete child widgets, Qt does it all for us
//    delete p_export;
}


void hk_kdecsvexportdialog::ok_clicked(void)
{
//  wanna_debug(true);
    set_filename(filefield->text().local8Bit().data());
    long ds=new_datasource(tablelist->currentText().local8Bit().data(),p_datasourcetype);
    set_presentationdatasource(ds);
    set_withheader(firstrow->isChecked());
    QString sep=columnseparatorfield->currentText();
    if (sep==p_tab) sep="\t";
    set_dataformat(textdelimiterfield->text().local8Bit().data(),sep.local8Bit().data());
    if ( execute()) accept();
KConfig* c=kapp->config();
  c->setGroup("CSVExport");
  c->writeEntry("Geometry",geometry());
}


void hk_kdecsvexportdialog::filebutton_clicked()
{

    p_file = KFileDialog::getOpenFileName( QString::null, QString::null, this,i18n("Select a CSV file"));
    filefield->setText(p_file);
}


void hk_kdecsvexportdialog::buttons_enabled()
{
    if (    !filefield->text().isEmpty()
        &&!columnseparatorfield->currentText().isEmpty()
        &&!tablelist->currentText().isEmpty()
        )
        buttonOk->setEnabled(true);
    else buttonOk->setEnabled(false);
}


void hk_kdecsvexportdialog::set_usetablelist()
{
    p_datasourcetype=dt_table;
    set_datasourcelist();
}

void hk_kdecsvexportdialog::set_useviewlist()
{
    p_datasourcetype=dt_view;
    set_datasourcelist();
}

void hk_kdecsvexportdialog::set_usequerylist()
{
    p_datasourcetype=dt_query;
    set_datasourcelist();
}


void hk_kdecsvexportdialog::set_database(hk_database* d)
{
    hk_presentation::set_database(d);
    set_datasourcelist();
}


void hk_kdecsvexportdialog::set_datasourcelist(void)
{
    tablelist->clear();
    hk_database* p_db=database();
    if (p_db==NULL)return ;
    vector<hk_string>* tbl=p_db->tablelist();;
    switch (p_datasourcetype)
    {
    case dt_table:
    {
        //tbl already set as default
        TextLabel1_2->setText( i18n("Tablename:"  ) );
	break;
    }
    case dt_query:
    {
        tbl=p_db->querylist();
        TextLabel1_2->setText( i18n("Queryname:"  ) );
	break;
    }
    case dt_view:
    {
        tbl=p_db->viewlist();
        TextLabel1_2->setText( i18n("Viewname:"  ) );
	break;
    }
    }
    vector<hk_string>::iterator it;
    if (tbl!=NULL)
    {
        for(it=tbl->begin();it!=tbl->end();it++)
        {
            QString l=QString::fromLocal8Bit ((*it).c_str());
            tablelist->insertItem(l);
            if (!p_tablename.isEmpty()&& p_tablename==l) tablelist->setCurrentItem(tablelist->count()-1);
        }
    }

}
