/***************************************************************************
                          dlg_newmatch.h  -  description
                             -------------------
    begin                : Tue Jun 25 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLG_NEWMATCH_H
#define DLG_NEWMATCH_H

#include <qwidget.h>
#include <kdialogbase.h>

#include "match_param.h"

/**
  *@author Troy Corbin Jr.
  */

class dlg_selectengine;
class dlg_selectemail;
class resource;
class QLabel;
class QSpinBox;
class QRadioButton;
class QCheckBox;
class QVBox;
class QHBox;
class QGrid;
class QButtonGroup;
class QGroupBox;
class KComboBox;

class dlg_newmatch : public KDialogBase
{
	Q_OBJECT
	private:
		resource					*myResource;
		match_param				*Param;
		dlg_selectengine	*EngineSelect;
		dlg_selectemail		*EmailSelect;

    QHBox             *BOX_Parent;
	    QVBox             *BOX_Players;
		    QGroupBox         *BOX_White;
			    QLabel            *IMAGE_White;
			    QVBox             *BOX_White_Detail;
				    QLabel            *LABEL_White_Name;
				    QButtonGroup      *GROUP_White_Type;
					    QRadioButton      *RADIO_White_Human;
					    QRadioButton      *RADIO_White_PC;
					    QRadioButton      *RADIO_White_Email;
	    QGrid             *GRID_White_Time;
		    QLabel            *LABEL_White_Base;
		    QSpinBox          *SPIN_White_Base;
		    QLabel            *LABEL_White_Inc;
		    QSpinBox          *SPIN_White_Inc;
		    QLabel            *LABEL_White_Moves;
		    QSpinBox          *SPIN_White_Moves;
		    QGroupBox         *BOX_Black;
			    QLabel            *IMAGE_Black;
			    QVBox             *BOX_Black_Detail;
				    QLabel            *LABEL_Black_Name;
				    QButtonGroup      *GROUP_Black_Type;
					    QRadioButton      *RADIO_Black_Human;
					    QRadioButton      *RADIO_Black_PC;
					    QRadioButton      *RADIO_Black_Email;
	    QGrid             *GRID_Black_Time;
		    QLabel            *LABEL_Black_Base;
		    QSpinBox          *SPIN_Black_Base;
		    QLabel            *LABEL_Black_Inc;
		    QSpinBox          *SPIN_Black_Inc;
		    QLabel            *LABEL_Black_Moves;
		    QSpinBox          *SPIN_Black_Moves;

  public:
                      dlg_newmatch(QWidget *parent=0, const char *name=0, resource *Rsrc=0);
                      ~dlg_newmatch();
                      match_param* paramaters( void ) { return Param; }
  protected slots:
    void              slotWhiteType( int );
    void              slotWhiteBase( int );
    void              slotWhiteMoves( int );
    void              slotWhiteInc( int );

    void              slotBlackType( int );
    void              slotBlackBase( int );
    void              slotBlackMoves( int );
    void              slotBlackInc( int );

		void							slotReparse( void );

  protected:
    void              setTCP( void );
    void              setTypes( void );
    void              setImages( void );
    void              setNames( void );
};

#endif
