/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef EDITCMD_H
#define EDITCMD_H

#include "itempart.h"

#include <qstring.h>

namespace KBabel
{

class EditCommand
{
public:
    enum Commands { Invalid, Begin, End, Insert, Delete };

    EditCommand();
    EditCommand( const int index, const Part part );
    virtual ~EditCommand() {};
    virtual Commands type() const { return Invalid; }
    virtual int terminator() const { return 0; }

    int index() const { return _index; }
    void setIndex( int index ) { _index=index; }
    Part part() const { return _part; }
    void setPart(Part part) {_part=part;}

    virtual bool merge( EditCommand* ) { return false;}

private:
   Part _part;
   int _index;
};


class BeginCommand : public EditCommand
{
public:
    BeginCommand( const int index, const Part part ) : EditCommand(index,part) {}
    virtual Commands type() const { return Begin; }
    virtual int terminator() const { return 1; }
};


class EndCommand : public EditCommand
{
public:
    EndCommand( const int index, const Part part ) : EditCommand(index,part) {}
    virtual Commands type() const { return End; }
    virtual int terminator() const { return -1; }
};



class DelTextCmd : public EditCommand
{
public:
    int offset;
    QString str;
    int pluralNumber;

    // have to handle deletion of current selection
    DelTextCmd(int offset, const QString &str, int pluralNumber );
    virtual Commands type() const { return Delete; }

    bool merge( EditCommand* other);
};

class InsTextCmd : public DelTextCmd
{

public:
    InsTextCmd(int offset,const QString &str, int pluralNumber );
    virtual Commands type() const { return Insert; }

    bool merge( EditCommand* other);
};

}

#endif // SETTINGS_H
