<?xml version='1.0'?>
<!-- vim:set sts=2 shiftwidth=2 syntax=sgml: -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'>

<xsl:include href="docbook/xsl/common/common.xsl"/>

<xsl:include href="synop.xsl"/>
<xsl:include href="lists.xsl"/>

<xsl:output method="text"
            encoding="ISO-8859-1"
            indent="no"/>


<xsl:template match="refsect2">
  <xsl:text>
.Sh "</xsl:text>
  <xsl:value-of select="substring-before(title[1],' ')"/>
  <xsl:text>"
</xsl:text>
  <xsl:apply-templates/>
</xsl:template>
<xsl:template match="refsect2/programlisting"></xsl:template>

<xsl:template match="refsect2/informaltable/tgroup/tbody/row">
  <xsl:text>.Ip "\(bu \s-1</xsl:text>
  <xsl:value-of select="entry[1]/parameter[1]"/>
  <xsl:text>\s0 \- </xsl:text>
  <xsl:value-of select="normalize-space(entry[2])"/>
  <xsl:text>"
</xsl:text>
</xsl:template>

<xsl:template match="refsect1">
  <xsl:text>
.SH "</xsl:text>
  <xsl:value-of select="translate(title[1],'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
  <xsl:text>"
</xsl:text>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="refsynopsisdiv">
  <xsl:text>
.SH "SYNOPSIS"
</xsl:text>
  <xsl:apply-templates/>
</xsl:template>


<xsl:template match="para">
  <xsl:variable name="foo">
    <xsl:apply-templates/>
  </xsl:variable>
  <xsl:text>
.PP
</xsl:text>
  <xsl:value-of select="normalize-space($foo)"/>
  <xsl:text>
</xsl:text>
</xsl:template>
  
<xsl:template match="refentry">
  <xsl:text>."Generated by db2man.xsl. Don't modify this, modify the source.
.de Sh \" Subsection
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Ip \" List item
.br
.ie \\n(.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.TH "</xsl:text>
  <xsl:value-of select="refnamediv/refname[1]"/>
  <xsl:text>" </xsl:text>
  <xsl:value-of select="refmeta/manvolnum[1]"/>
  <xsl:text> "" "" "</xsl:text>
  <xsl:value-of select="refentryinfo/title"/>
  <xsl:text>"
</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>
.SH AUTHOR
</xsl:text>
  <xsl:choose>
    <xsl:when test="/refentry">
      <xsl:apply-templates select="/refentry/refentryinfo/*"/>
    </xsl:when>
    <xsl:when test="/article">
      <xsl:apply-templates select="/article/articleinfo/*"/>
    </xsl:when>
    <xsl:when test="/book">
    </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template match="refmeta"></xsl:template>
<xsl:template match="title"></xsl:template>
<xsl:template match="abstract"></xsl:template>

<xsl:template match="author">
  <xsl:call-template name="person.name"/>
  <xsl:apply-templates select="./affiliation/address/email" />
</xsl:template>

<xsl:template match="copyright">
  <xsl:text>Copyright </xsl:text>
  <xsl:apply-templates select="./year" />
  <xsl:text>
.Sp
</xsl:text>
</xsl:template>

<xsl:template match="email">
  <xsl:text>  &lt;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>&gt;</xsl:text>
</xsl:template>

<xsl:template match="refnamediv">
  <xsl:text>.SH NAME
</xsl:text>
  <xsl:value-of select="refname"/>
  <xsl:text> \- </xsl:text>
  <xsl:value-of select="refpurpose"/>
</xsl:template>

<xsl:template match="refentry/refentryinfo"></xsl:template>

<xsl:template match="option">
  <xsl:text>\fB</xsl:text><xsl:apply-templates/><xsl:text>\fR</xsl:text>
</xsl:template>

<xsl:template match="replaceable">
  <xsl:text>\fI</xsl:text><xsl:apply-templates/><xsl:text>\fR</xsl:text>
</xsl:template>

<xsl:template match="filename">
  <xsl:text>
.FN </xsl:text><xsl:apply-templates/>
</xsl:template>

<xsl:template match="userinput">
  <xsl:text>
.IP
.B </xsl:text><xsl:apply-templates/>
</xsl:template>

<xsl:template match="envar">
  <xsl:text>\fB</xsl:text><xsl:apply-templates/><xsl:text>\fR</xsl:text>
</xsl:template>

<xsl:template match="filename">
  <xsl:text>\fI</xsl:text><xsl:apply-templates/><xsl:text>\fR</xsl:text>
</xsl:template>

<xsl:template match="ulink">
  <xsl:apply-templates/>
  <xsl:text>: \fI</xsl:text>
  <xsl:value-of select="@url"/>
  <xsl:text>\fR</xsl:text>
</xsl:template>

<xsl:template match="article">
  <xsl:apply-templates select="refentry"/>
</xsl:template>

</xsl:stylesheet>
