// Demo of a QString slot
// Implemented by Marcus Urban

using System;
using Qt;

public class MyWidget : QVBox
{
	QLineEdit lineEdit;
	QLabel label;

	public MyWidget (QWidget parent, String name) : base (parent, name)
	{
		lineEdit = new QLineEdit( this, "lineEdit" );
		label = new QLabel( this, "label" );
		label.SetText("Default");
		
		QObject.Connect( lineEdit, SIGNAL("textChanged(QString)"),
			label, "SetText(QString)" );
	}


	public MyWidget (QWidget parent) : this (parent, "") {}
	public MyWidget () : this (null, "") {}
}

public class Example {

	public static int Main (String[] args)
	{
		QApplication a = new QApplication (args);
		
		MyWidget w = new MyWidget ();
		a.SetMainWidget (w);
		w.Show ();
		return a.Exec ();
	}
}
