// QPopupMenu.cs - A Qt to C# binding.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Regenerated by Adam Treat on August 03 2002
//
// TODO
// o Override Dispose method, make sure slots are disconnected.

namespace Qt {

    using Qt;
    using System;
	using System.Collections;
    using System.Runtime.InteropServices;

    public class QPopupMenu : QFrame, IQMenuData, IDisposable {
		
		private Hashtable menuConnections;

		public Hashtable MenuConnections {
			get { return menuConnections; }
		}
        
		[DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_new_QPopupMenu (IntPtr parent, string name);
        public QPopupMenu (QWidget parent, string name) : this (QNull.Instance)
        {
            qparent = parent;
            if (qparent == null) parent = new QWidget (IntPtr.Zero);
            rawObject = qt_new_QPopupMenu (parent.RawObject, name);
            if (qparent == null) RegisterObject (this);
            else qparent.AddChild (this);
        }

        public QPopupMenu () : this (new QWidget ()) {}

        public QPopupMenu (QWidget parent) : this (parent, "") {}

        internal QPopupMenu (IntPtr ptr) : this (QNull.Instance)
        {
            rawObject = ptr;
            RegisterObject(this);
        }

        internal QPopupMenu (QNull dummy) : base (QNull.Instance)
		{
			menuConnections = new Hashtable();
		}

        ~QPopupMenu ()
        {
            Dispose (false);
        }

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_del_QPopupMenu (IntPtr obj);
		internal override void Delete ()
		{
			if (deleted) return;

			qt_del_QPopupMenu (rawObject);
			deleted = true;
		}

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_popup (IntPtr raw, IntPtr pos, int indexAtPoint);
        public void Popup (QPoint pos, int indexAtPoint)
        {
            qt_QPopupMenu_popup (rawObject, pos.RawObject, indexAtPoint);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_updateItem (IntPtr raw, int identifier);
        public void UpdateItem (int identifier)
        {
            qt_QPopupMenu_updateItem (rawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_setCheckable (IntPtr raw, bool arg1);
        public void SetCheckable (bool arg1)
        {
            qt_QPopupMenu_setCheckable (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QPopupMenu_isCheckable (IntPtr raw);
        public bool IsCheckable ()
        {
            return qt_QPopupMenu_isCheckable (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_setFont (IntPtr raw, IntPtr arg1);
        public void SetFont (QFont arg1)
        {
            qt_QPopupMenu_setFont (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_show (IntPtr raw);
        public void Show ()
        {
            qt_QPopupMenu_show (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_hide (IntPtr raw);
        public void Hide ()
        {
            qt_QPopupMenu_hide (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_exec (IntPtr raw);
        public int Exec ()
        {
            return qt_QPopupMenu_exec (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_exec1 (IntPtr raw, IntPtr pos, int indexAtPoint);
        public int Exec (QPoint pos, int indexAtPoint)
        {
            return qt_QPopupMenu_exec1 (rawObject, pos.RawObject, indexAtPoint);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_setActiveItem (IntPtr raw, int arg1);
        public void SetActiveItem (int arg1)
        {
            qt_QPopupMenu_setActiveItem (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QPopupMenu_sizeHint (IntPtr raw);
        public QSize SizeHint ()
        {
            return (QSize)LookupObject (qt_QPopupMenu_sizeHint (rawObject), typeof(QSize));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_idAt (IntPtr raw, int index);
        public int IdAt (int index)
        {
            return qt_QPopupMenu_idAt (rawObject, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_idAt1 (IntPtr raw, IntPtr pos);
        public int IdAt (QPoint pos)
        {
            return qt_QPopupMenu_idAt1 (rawObject, pos.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QPopupMenu_customWhatsThis (IntPtr raw);
        public bool CustomWhatsThis ()
        {
            return qt_QPopupMenu_customWhatsThis (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_insertTearOffHandle (IntPtr raw, int identifier, int index);
        public int InsertTearOffHandle (int identifier, int index)
        {
            return qt_QPopupMenu_insertTearOffHandle (rawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_activateItemAt (IntPtr raw, int index);
        public void ActivateItemAt (int index)
        {
            qt_QPopupMenu_activateItemAt (rawObject, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QPopupMenu_itemGeometry (IntPtr raw, int index);
        public QRect ItemGeometry (int index)
        {
            return (QRect)LookupObject (qt_QPopupMenu_itemGeometry (rawObject, index), typeof(QRect));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_itemHeight (IntPtr raw, int arg1);
        protected int ItemHeight (int arg1)
        {
            return qt_QPopupMenu_itemHeight (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_itemHeight1 (IntPtr raw, IntPtr mi);
        protected int ItemHeight (QMenuItem mi)
        {
            return qt_QPopupMenu_itemHeight1 (rawObject, mi.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_drawItem (IntPtr raw, IntPtr p, int tab, IntPtr mi, bool act, int x, int y, int w, int h);
        protected void DrawItem (QPainter p, int tab, QMenuItem mi, bool act, int x, int y, int w, int h)
        {
            qt_QPopupMenu_drawItem (rawObject, p.RawObject, tab, mi.RawObject, act, x, y, w, h);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_drawContents (IntPtr raw, IntPtr arg1);
        protected void DrawContents (QPainter arg1)
        {
            qt_QPopupMenu_drawContents (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QPopupMenu_styleChange (IntPtr raw, IntPtr arg1);
        protected void StyleChange (QStyle arg1)
        {
            qt_QPopupMenu_styleChange (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_columns (IntPtr raw);
        protected int Columns ()
        {
            return qt_QPopupMenu_columns (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QPopupMenu_focusNextPrevChild (IntPtr raw, bool next);
        protected bool FocusNextPrevChild (bool next)
        {
            return qt_QPopupMenu_focusNextPrevChild (rawObject, next);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QPopupMenu_itemAtPos (IntPtr raw, IntPtr arg1, bool ignoreSeparator);
        protected int ItemAtPos (QPoint arg1, bool ignoreSeparator)
        {
            return qt_QPopupMenu_itemAtPos (rawObject, arg1.RawObject, ignoreSeparator);
        }

        public void Popup (QPoint pos)
        {
            Popup(pos, (int) 0);
        }

        public int Exec (QPoint pos)
        {
            return Exec(pos, (int) 0);
        }

        public int InsertTearOffHandle ()
        {
            return InsertTearOffHandle((int) -1);
        }

        public int InsertTearOffHandle (int identifier)
        {
            return InsertTearOffHandle(identifier, (int) -1);
        }

        protected int ItemAtPos (QPoint arg1)
        {
            return ItemAtPos(arg1, true);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QPopupMenu_QMenuData (IntPtr raw);
        public IntPtr QMenuData ()
        {
            return qt_QPopupMenu_QMenuData (rawObject);
        }

        // Begin interface methods.


		//********************* A temporary hack to divert connections to CSharpConnect *****************//

		public int InsertItem (string text, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (text, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (QIconSet icon, string text, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (icon, text, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (pixmap, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (icon, pixmap, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public bool ConnectItem (int identifier, QObject receiver, string member)
		{
			return Qt.QMenuData.ConnectItem (this, QMenuData (), identifier, receiver, member);
		}

		public bool DisconnectItem (int identifier, QObject receiver, string member)
		{
			return Qt.QMenuData.DisconnectItem (this, QMenuData (), identifier, receiver, member);
		}

		//********************* A temporary hack to divert connections to CSharpConnect *****************//

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern uint qt_QMenuData_count (IntPtr raw);
        public uint Count ()
        {
            return qt_QMenuData_count (QMenuData ());
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem4 (IntPtr raw, IntPtr text, int identifier, int index);
        public int InsertItem (string text, int identifier, int index)
        {
            return qt_QMenuData_insertItem4 (QMenuData (), new QString (text).RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem5 (IntPtr raw, IntPtr icon, IntPtr text, int identifier, int index);
        public int InsertItem (QIconSet icon, string text, int identifier, int index)
        {
            return qt_QMenuData_insertItem5 (QMenuData (), icon.RawObject, new QString (text).RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem6 (IntPtr raw, IntPtr text, IntPtr popup, int identifier, int index);
        public int InsertItem (string text, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem6 (QMenuData (), new QString (text).RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem7 (IntPtr raw, IntPtr icon, IntPtr text, IntPtr popup, int identifier, int index);
        public int InsertItem (QIconSet icon, string text, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem7 (QMenuData (), icon.RawObject, new QString (text).RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem8 (IntPtr raw, IntPtr pixmap, int identifier, int index);
        public int InsertItem (QPixmap pixmap, int identifier, int index)
        {
            return qt_QMenuData_insertItem8 (QMenuData (), pixmap.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem9 (IntPtr raw, IntPtr icon, IntPtr pixmap, int identifier, int index);
        public int InsertItem (QIconSet icon, QPixmap pixmap, int identifier, int index)
        {
            return qt_QMenuData_insertItem9 (QMenuData (), icon.RawObject, pixmap.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem10 (IntPtr raw, IntPtr pixmap, IntPtr popup, int identifier, int index);
        public int InsertItem (QPixmap pixmap, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem10 (QMenuData (), pixmap.RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem11 (IntPtr raw, IntPtr icon, IntPtr pixmap, IntPtr popup, int identifier, int index);
        public int InsertItem (QIconSet icon, QPixmap pixmap, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem11 (QMenuData (), icon.RawObject, pixmap.RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem12 (IntPtr raw, IntPtr widget, int identifier, int index);
        public int InsertItem (QWidget widget, int identifier, int index)
        {
            return qt_QMenuData_insertItem12 (QMenuData (), widget.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem13 (IntPtr raw, IntPtr icon, IntPtr custom, int identifier, int index);
        public int InsertItem (QIconSet icon, QCustomMenuItem custom, int identifier, int index)
        {
            return qt_QMenuData_insertItem13 (QMenuData (), icon.RawObject, custom.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem14 (IntPtr raw, IntPtr custom, int identifier, int index);
        public int InsertItem (QCustomMenuItem custom, int identifier, int index)
        {
            return qt_QMenuData_insertItem14 (QMenuData (), custom.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertSeparator (IntPtr raw, int index);
        public int InsertSeparator (int index)
        {
            return qt_QMenuData_insertSeparator (QMenuData (), index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_removeItem (IntPtr raw, int identifier);
        public void RemoveItem (int identifier)
        {
            qt_QMenuData_removeItem (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_removeItemAt (IntPtr raw, int index);
        public void RemoveItemAt (int index)
        {
            qt_QMenuData_removeItemAt (QMenuData (), index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_clear (IntPtr raw);
        public void Clear ()
        {
            qt_QMenuData_clear (QMenuData ());
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_accel (IntPtr raw, int identifier);
        public QKeySequence Accel (int identifier)
        {
            return (QKeySequence)LookupObject (qt_QMenuData_accel (QMenuData (), identifier), typeof(QKeySequence));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setAccel (IntPtr raw, IntPtr key, int identifier);
        public void SetAccel (QKeySequence key, int identifier)
        {
            qt_QMenuData_setAccel (QMenuData (), key.RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_iconSet (IntPtr raw, int identifier);
        public QIconSet IconSet (int identifier)
        {
            return (QIconSet)LookupObject (qt_QMenuData_iconSet (QMenuData (), identifier), typeof(QIconSet));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_text (IntPtr raw, int identifier);
        public string Text (int identifier)
        {
			QString qstr = new QString (qt_QMenuData_text (QMenuData (), identifier));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_pixmap (IntPtr raw, int identifier);
        public QPixmap Pixmap (int identifier)
        {
            return (QPixmap)LookupObject (qt_QMenuData_pixmap (QMenuData (), identifier), typeof(QPixmap));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setWhatsThis (IntPtr raw, int identifier, IntPtr arg1);
        public void SetWhatsThis (int identifier, string arg1)
        {
            qt_QMenuData_setWhatsThis (QMenuData (), identifier, new QString (arg1).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_whatsThis (IntPtr raw, int identifier);
        public string WhatsThis (int identifier)
        {
			QString qstr = new QString (qt_QMenuData_whatsThis (QMenuData (), identifier));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem (IntPtr raw, int identifier, IntPtr text);
        public void ChangeItem (int identifier, string text)
        {
            qt_QMenuData_changeItem (QMenuData (), identifier, new QString (text).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem1 (IntPtr raw, int identifier, IntPtr pixmap);
        public void ChangeItem (int identifier, QPixmap pixmap)
        {
            qt_QMenuData_changeItem1 (QMenuData (), identifier, pixmap.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem2 (IntPtr raw, int identifier, IntPtr icon, IntPtr text);
        public void ChangeItem (int identifier, QIconSet icon, string text)
        {
            qt_QMenuData_changeItem2 (QMenuData (), identifier, icon.RawObject, new QString (text).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem3 (IntPtr raw, int identifier, IntPtr icon, IntPtr pixmap);
        public void ChangeItem (int identifier, QIconSet icon, QPixmap pixmap)
        {
            qt_QMenuData_changeItem3 (QMenuData (), identifier, icon.RawObject, pixmap.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem4 (IntPtr raw, IntPtr text, int identifier);
        public void ChangeItem (string text, int identifier)
        {
            qt_QMenuData_changeItem4 (QMenuData (), new QString (text).RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem5 (IntPtr raw, IntPtr pixmap, int identifier);
        public void ChangeItem (QPixmap pixmap, int identifier)
        {
            qt_QMenuData_changeItem5 (QMenuData (), pixmap.RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem6 (IntPtr raw, IntPtr icon, IntPtr text, int identifier);
        public void ChangeItem (QIconSet icon, string text, int identifier)
        {
            qt_QMenuData_changeItem6 (QMenuData (), icon.RawObject, new QString (text).RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemActive (IntPtr raw, int identifier);
        public bool IsItemActive (int identifier)
        {
            return qt_QMenuData_isItemActive (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemEnabled (IntPtr raw, int identifier);
        public bool IsItemEnabled (int identifier)
        {
            return qt_QMenuData_isItemEnabled (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setItemEnabled (IntPtr raw, int identifier, bool enable);
        public void SetItemEnabled (int identifier, bool enable)
        {
            qt_QMenuData_setItemEnabled (QMenuData (), identifier, enable);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemChecked (IntPtr raw, int identifier);
        public bool IsItemChecked (int identifier)
        {
            return qt_QMenuData_isItemChecked (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setItemChecked (IntPtr raw, int identifier, bool check);
        public void SetItemChecked (int identifier, bool check)
        {
            qt_QMenuData_setItemChecked (QMenuData (), identifier, check);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_indexOf (IntPtr raw, int identifier);
        public int IndexOf (int identifier)
        {
            return qt_QMenuData_indexOf (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setId (IntPtr raw, int index, int identifier);
        public void SetId (int index, int identifier)
        {
            qt_QMenuData_setId (QMenuData (), index, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_setItemParameter (IntPtr raw, int identifier, int param);
        public bool SetItemParameter (int identifier, int param)
        {
            return qt_QMenuData_setItemParameter (QMenuData (), identifier, param);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_itemParameter (IntPtr raw, int identifier);
        public int ItemParameter (int identifier)
        {
            return qt_QMenuData_itemParameter (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findItem (IntPtr raw, int identifier);
        public QMenuItem FindItem (int identifier)
        {
            return (QMenuItem)LookupObject (qt_QMenuData_findItem (QMenuData (), identifier), typeof(QMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findItem1 (IntPtr raw, int identifier, IntPtr parent);
        public QMenuItem FindItem (int identifier, QMenuData parent)
        {
            return (QMenuItem)LookupObject (qt_QMenuData_findItem1 (QMenuData (), identifier, parent.RawObject), typeof(QMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findPopup (IntPtr raw, IntPtr arg1, int[] index);
        public QMenuItem FindPopup (QPopupMenu arg1, int[] index)
        {
            return (QMenuItem)LookupObject (qt_QMenuData_findPopup (QMenuData (), arg1.RawObject, index), typeof(QMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_menuInsPopup (IntPtr raw, IntPtr arg1);
        protected void MenuInsPopup (QPopupMenu arg1)
        {
            qt_QMenuData_menuInsPopup (QMenuData (), arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_menuDelPopup (IntPtr raw, IntPtr arg1);
        protected void MenuDelPopup (QPopupMenu arg1)
        {
            qt_QMenuData_menuDelPopup (QMenuData (), arg1.RawObject);
        }

        public int InsertItem (string text, QObject receiver, string member)
        {
            return InsertItem(text, receiver, member, new QKeySequence ());
        }

        public int InsertItem (string text, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(text, receiver, member, accel, (int) -1);
        }

        public int InsertItem (string text, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(text, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QObject receiver, string member)
        {
            return InsertItem(icon, text, receiver, member, new QKeySequence ());
        }

        public int InsertItem (QIconSet icon, string text, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(icon, text, receiver, member, accel, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(icon, text, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QObject receiver, string member)
        {
            return InsertItem(pixmap, receiver, member, new QKeySequence ());
        }

        public int InsertItem (QPixmap pixmap, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(pixmap, receiver, member, accel, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(pixmap, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member)
        {
            return InsertItem(icon, pixmap, receiver, member, new QKeySequence ());
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(icon, pixmap, receiver, member, accel, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(icon, pixmap, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (string text)
        {
            return InsertItem(text, (int) -1);
        }

        public int InsertItem (string text, int identifier)
        {
            return InsertItem(text, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text)
        {
            return InsertItem(icon, text, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, int identifier)
        {
            return InsertItem(icon, text, identifier, (int) -1);
        }

        public int InsertItem (string text, QPopupMenu popup)
        {
            return InsertItem(text, popup, (int) -1);
        }

        public int InsertItem (string text, QPopupMenu popup, int identifier)
        {
            return InsertItem(text, popup, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QPopupMenu popup)
        {
            return InsertItem(icon, text, popup, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QPopupMenu popup, int identifier)
        {
            return InsertItem(icon, text, popup, identifier, (int) -1);
        }

        public int InsertItem (QPixmap pixmap)
        {
            return InsertItem(pixmap, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, int identifier)
        {
            return InsertItem(pixmap, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap)
        {
            return InsertItem(icon, pixmap, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, int identifier)
        {
            return InsertItem(icon, pixmap, identifier, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QPopupMenu popup)
        {
            return InsertItem(pixmap, popup, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QPopupMenu popup, int identifier)
        {
            return InsertItem(pixmap, popup, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QPopupMenu popup)
        {
            return InsertItem(icon, pixmap, popup, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QPopupMenu popup, int identifier)
        {
            return InsertItem(icon, pixmap, popup, identifier, (int) -1);
        }

        public int InsertItem (QWidget widget)
        {
            return InsertItem(widget, (int) -1);
        }

        public int InsertItem (QWidget widget, int identifier)
        {
            return InsertItem(widget, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QCustomMenuItem custom)
        {
            return InsertItem(icon, custom, (int) -1);
        }

        public int InsertItem (QIconSet icon, QCustomMenuItem custom, int identifier)
        {
            return InsertItem(icon, custom, identifier, (int) -1);
        }

        public int InsertItem (QCustomMenuItem custom)
        {
            return InsertItem(custom, (int) -1);
        }

        public int InsertItem (QCustomMenuItem custom, int identifier)
        {
            return InsertItem(custom, identifier, (int) -1);
        }

        public int InsertSeparator ()
        {
            return InsertSeparator((int) -1);
        }

        public QMenuItem FindPopup (QPopupMenu arg1)
        {
            return FindPopup(arg1, new int[]{0});
        }
    }
}
