#!/usr/bin/env python

# Qt tutorial 5.

import sys
import qt


class MyWidget(qt.QVBox):
    def __init__(self, parent=None, name=None):
        qt.QVBox.__init__(self, parent, name)

        quit = qt.QPushButton("Quit", self, "quit")
        quit.setFont(qt.QFont("Times", 18, qt.QFont.Bold))

        self.connect(quit, qt.SIGNAL("clicked()"), qt.qApp, qt.SLOT("quit()"))

        lcd = qt.QLCDNumber(2, self, "lcd")

        slider = qt.QSlider(qt.Qt.Horizontal, self, "slider")
        slider.setRange(0, 99)
        slider.setValue(0)

        self.connect(slider, qt.SIGNAL("valueChanged(int)"), lcd, qt.SLOT("display(int)"))


a = qt.QApplication(sys.argv)

w = MyWidget()
a.setMainWidget(w)
w.show()
sys.exit(a.exec_loop())
