
  

#include <qcstring.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <qframe.h>
#include "qframe_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QFrameImp::QFrameImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QFrameImp::~QFrameImp()
{
}

void QFrameImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_frameStyle_2, "frameStyle" },
        { Method_setFrameStyle_3, "setFrameStyle" },
        { Method_frameWidth_4, "frameWidth" },
        { Method_contentsRect_5, "contentsRect" },
        { Method_lineShapesOk_6, "lineShapesOk" },
        { Method_sizeHint_7, "sizeHint" },
        { Method_frameShape_8, "frameShape" },
        { Method_setFrameShape_9, "setFrameShape" },
        { Method_frameShadow_10, "frameShadow" },
        { Method_setFrameShadow_11, "setFrameShadow" },
        { Method_lineWidth_12, "lineWidth" },
        { Method_setLineWidth_13, "setLineWidth" },
        { Method_margin_14, "margin" },
        { Method_setMargin_15, "setMargin" },
        { Method_midLineWidth_16, "midLineWidth" },
        { Method_setMidLineWidth_17, "setMidLineWidth" },
        { Method_frameRect_18, "frameRect" },
        { Method_setFrameRect_19, "setFrameRect" },
	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].id ) {
        if ( lastName != methods[idx].name ) {
            QFrameImp *meth = new QFrameImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


    //
    // Define the enum constants
    //
    struct EnumValue {
	const char *id;
	int val;
    };

    EnumValue enums[] = {

        // enum Shape
        { "NoFrame", QFrame::NoFrame },
        { "Box", QFrame::Box },
        { "Panel", QFrame::Panel },
        { "WinPanel", QFrame::WinPanel },
        { "HLine", QFrame::HLine },
        { "VLine", QFrame::VLine },
        { "StyledPanel", QFrame::StyledPanel },
        { "PopupPanel", QFrame::PopupPanel },
        { "MenuBarPanel", QFrame::MenuBarPanel },
        { "ToolBarPanel", QFrame::ToolBarPanel },
        { "LineEditPanel", QFrame::LineEditPanel },
        { "TabWidgetPanel", QFrame::TabWidgetPanel },
        { "GroupBoxPanel", QFrame::GroupBoxPanel },
        { "MShape", QFrame::MShape },
        // enum Shadow
        { "Plain", QFrame::Plain },
        { "Raised", QFrame::Raised },
        { "Sunken", QFrame::Sunken },
        { "MShadow", QFrame::MShadow },
	{ 0, 0 }
    };

    int enumidx = 0;
    do {
        object.put( exec, enums[enumidx].id, KJS::Number(enums[enumidx].val), KJS::ReadOnly );
        ++enumidx;
    } while( enums[enumidx].id );

}

QFrame *QFrameImp::toQFrame( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        QObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<QFrame *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "QFrame" )
        return 0;

    return (QFrame *)( op->toVoidStar() );
}


KJS::Object QFrameImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QFrame_1:
             return QFrame_1( exec, args );
             break;
    
         default:
             break;
    }

    QString msg = i18n("QFrameCons has no constructor with id '%1'.").arg(id);
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Object QFrameImp::QFrame_1( KJS::ExecState *exec, const KJS::List &args )
{
    
    // TODO
    QWidget *arg0 = 0L;
        
    // TODO
    QWidget *arg1 = 0L;
        
    // TODO
    QWidget *arg2 = 0L;
        
}
    
KJS::Value QFrameImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QFrameImp::toQFrame( self );

    switch( id ) {

    case Method_frameStyle_2:
        return frameStyle_2( exec, self, args );
        break;
    
    case Method_setFrameStyle_3:
        return setFrameStyle_3( exec, self, args );
        break;
    
    case Method_frameWidth_4:
        return frameWidth_4( exec, self, args );
        break;
    
    case Method_contentsRect_5:
        return contentsRect_5( exec, self, args );
        break;
    
    case Method_lineShapesOk_6:
        return lineShapesOk_6( exec, self, args );
        break;
    
    case Method_sizeHint_7:
        return sizeHint_7( exec, self, args );
        break;
    
    case Method_frameShape_8:
        return frameShape_8( exec, self, args );
        break;
    
    case Method_setFrameShape_9:
        return setFrameShape_9( exec, self, args );
        break;
    
    case Method_frameShadow_10:
        return frameShadow_10( exec, self, args );
        break;
    
    case Method_setFrameShadow_11:
        return setFrameShadow_11( exec, self, args );
        break;
    
    case Method_lineWidth_12:
        return lineWidth_12( exec, self, args );
        break;
    
    case Method_setLineWidth_13:
        return setLineWidth_13( exec, self, args );
        break;
    
    case Method_margin_14:
        return margin_14( exec, self, args );
        break;
    
    case Method_setMargin_15:
        return setMargin_15( exec, self, args );
        break;
    
    case Method_midLineWidth_16:
        return midLineWidth_16( exec, self, args );
        break;
    
    case Method_setMidLineWidth_17:
        return setMidLineWidth_17( exec, self, args );
        break;
    
    case Method_frameRect_18:
        return frameRect_18( exec, self, args );
        break;
    
    case Method_setFrameRect_19:
        return setFrameRect_19( exec, self, args );
        break;
    
    default:
        break;
    }

    QString msg = i18n( "QFrameImp has no method with id '%1'." ).arg( id );
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Value QFrameImp::frameStyle_2( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->frameStyle(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QFrameImp::setFrameStyle_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    int arg0 = (args.size() >= 1) ? args[0].toInteger(exec) : -1;
        
      instance->setFrameStyle( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QFrameImp::frameWidth_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->frameWidth(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QFrameImp::contentsRect_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->contentsRect(  );
      return KJS::Value(); // Returns 'QRect'
      
}
    
KJS::Value QFrameImp::lineShapesOk_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      bool ret;
      ret = instance->lineShapesOk(  );
      return KJS::Boolean( ret );
      
}
    
KJS::Value QFrameImp::sizeHint_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->sizeHint(  );
      return KJS::Value(); // Returns 'QSize'
      
}
    
KJS::Value QFrameImp::frameShape_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->frameShape(  );
      return KJS::Value(); // Returns 'Shape'
      
}
    
KJS::Value QFrameImp::setFrameShape_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    QFrame::Shape arg0; // TODO (hack for frame)
        
      instance->setFrameShape( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QFrameImp::frameShadow_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->frameShadow(  );
      return KJS::Value(); // Returns 'Shadow'
      
}
    
KJS::Value QFrameImp::setFrameShadow_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    QFrame::Shadow arg0; // TODO (hack for frame)
        
      instance->setFrameShadow( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QFrameImp::lineWidth_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->lineWidth(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QFrameImp::setLineWidth_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    int arg0 = (args.size() >= 1) ? args[0].toInteger(exec) : -1;
        
      instance->setLineWidth( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QFrameImp::margin_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->margin(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QFrameImp::setMargin_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    int arg0 = (args.size() >= 1) ? args[0].toInteger(exec) : -1;
        
      instance->setMargin( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QFrameImp::midLineWidth_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->midLineWidth(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QFrameImp::setMidLineWidth_17( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    int arg0 = (args.size() >= 1) ? args[0].toInteger(exec) : -1;
        
      instance->setMidLineWidth( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QFrameImp::frameRect_18( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->frameRect(  );
      return KJS::Value(); // Returns 'QRect'
      
}
    
KJS::Value QFrameImp::setFrameRect_19( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    QRect arg0 = extractQRect(exec, args, 0);
        
      instance->setFrameRect( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    

} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


