
  

#ifndef KJSEMBED_QCanvasView_H
#define KJSEMBED_QCanvasView_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class QCanvasView;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for QCanvasView methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class QCanvasViewImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QCanvasView_1,
       Constructor_QCanvasView_2,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_canvas_4,
       Method_setCanvas_5,
       Method_worldMatrix_6,
       Method_inverseWorldMatrix_7,
       Method_setWorldMatrix_8,
       Method_Last = -1
   };

   QCanvasViewImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~QCanvasViewImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static QCanvasView *toQCanvasView( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object QCanvasView_1( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object QCanvasView_2( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value canvas_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setCanvas_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value worldMatrix_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value inverseWorldMatrix_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setWorldMatrix_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   QCanvasView *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvasView_H

// Local Variables:
// c-basic-offset: 4
// End:


