/*
 *  Copyright (C) 2001-2003, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <qevent.h>
#include <qtextstream.h>

#include "global.h"

#include <kjs/interpreter.h>
#include <kjs/types.h>
#include <kjs/ustring.h>

#include "jsbinding.h"
#include "jsobjectproxy.h"
#include "jsobjectproxy_imp.h"
#include "jsvalueproxy_imp.h"

#include "jsopaqueproxy_imp.h"
#include "jsopaqueproxy.h"

namespace KJSEmbed {

typedef Bindings::JSOpaqueProxyImp JSOpaqueProxyImp;

JSOpaqueProxy::JSOpaqueProxy()
    : JSProxy( JSProxy::OpaqueProxy ), ptr(0), textstream(0), event(0)
{
}

JSOpaqueProxy::JSOpaqueProxy( void *ptr, const char *ptype )
    : JSProxy( JSProxy::OpaqueProxy ), ptr(0), textstream(0), event(0)
{
    setValue( ptr, ptype );
}

JSOpaqueProxy::JSOpaqueProxy( QTextStream *ts )
    : JSProxy( JSProxy::OpaqueProxy ), ptr(0), textstream(0)
{
    setValue( ts );
}

JSOpaqueProxy::JSOpaqueProxy( const QEvent *ev )
    : JSProxy( JSProxy::OpaqueProxy ), ptr(0), textstream(0), event(0)
{
    setValue( ev );
}

JSOpaqueProxy::~JSOpaqueProxy()
{
    if ( textstream )
	delete textstream;
/*
    else
	delete ptr;  // can we really do this?
    // not according to valgrind:
==32497== 11 errors in context 5 of 5:
==32497== Invalid free() / delete / delete[]
==32497==    at 0x40027C2D: __builtin_delete (vg_replace_malloc.c:233)
==32497==    by 0x40027C4B: operator delete(void*) (vg_replace_malloc.c:242)
==32497==    by 0x402918CB: KJSEmbed::JSOpaqueProxy::~JSOpaqueProxy() (/home/kdedev/cvs/kdebindings/kjsembed/jsopaqueproxy.cpp:69)
==32497==    by 0x4182A757: KJS::Collector::collect() (/home/kdedev/cvs/kdelibs/kjs/collector.cpp:276)
==32497==    Address 0xBFFFE7C0 is on thread 1's stack
*/
}

QString JSOpaqueProxy::typeName() const
{
    return ptrtype;
}

bool JSOpaqueProxy::inherits( const char *clazz )
{
    return (ptrtype == clazz);
}

void JSOpaqueProxy::setValue( void *ptr, const char *ptype )
{
    kdDebug(80001) << "JSOpaqueProxy::setValue() pointer, type is " << ptype << endl;

    if ( ptrtype == "QTextStream" )
	setValue( static_cast<QTextStream *>(ptr) );
    else if ( ptrtype == "QEvent" )
	setValue( static_cast<QEvent *>(ptr) );
    else {
	this->ptr = ptr;
	this->ptrtype = ptype ? ptype : "void";
    }
}

void JSOpaqueProxy::setValue( QTextStream *ts )
{
    ptr = ts;
    textstream = ts;
    ptrtype = "QTextStream";
}

void JSOpaqueProxy::setValue( const QEvent *ev )
{
    ptr = (void*)ev;
    event = ev;
    ptrtype = "QEvent";
}

QTextStream *JSOpaqueProxy::toTextStream()
{
    return textstream;
}

const QEvent *JSOpaqueProxy::toEvent()
{
    return event;
}

void JSOpaqueProxy::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    MethodTable methods[] = {
	{ JSOpaqueProxyImp::MethodTypeName, "typeName" },
	{ 0, 0 }
    };

    int i = 0;
    do {
	JSOpaqueProxyImp *obj = new JSOpaqueProxyImp( exec, methods[i].id, this );
	obj->setName( KJS::Identifier( methods[i].name ) );
	object.put( exec , obj->name(), KJS::Object(obj) );
	i++;
    } while( methods[i].id );
}

KJS::UString JSOpaqueProxy::toString( KJS::ExecState */*exec*/ ) const
{
    QString s( "%1 (%2)" );
    return KJS::UString( s.arg("JSOpaqueProxy").arg(ptrtype) );
}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:

