/*
* To use this fuction provide the ui file name, the parent
* that will handle the slots of the form, and the parent
* widget that will handle the UI portion.
*
* var form = kjsuic("EnvelopeMakerUI.ui", this, this);
* println(dump(form));
*
* This will then return you a widget object that has properties
* that are the main child widgets in the UI file.  So if you have
* a KLineEdit called "myLineEdit" in the UI file then there would
* be a member of the form called myLineEdit.  (ex: form.myLineEdit )
*
* If there are container widgets present then the children will show
* up as properties of those widgets.  So if you have a groupbox called
* "Group" and a KLineEdit inside of it called "editor" you would address
* this as "Group.editor".
*
* An important note:   Take care when using UI files with this that have
* widget names that do not conflict with current Qt properties as the Qt
* properties will take precident over the added widgets.
*/

function kjsuic(uifile, slotParent, parent)
{
        var widget = Factory.loadui(uifile, slotParent, parent);
        var lst = widget.children();
        addChildren( widget )
        return widget;
}

function addChildren( widget )
{
	var lst = widget.children();
        for( var idx = 0; idx < lst.length; ++idx)
        {
                var str = "widget." + lst[idx] + " = widget.child('" + lst[idx] + "');";
                eval(str);
		var typeName = widget.child(lst[idx]).className();

		if( typeName == "QGroupBox" || typeName == "QButtonGroup" || typeName == "QFrame")
		{
			eval("addChildren( widget." + lst[idx] + ");");
		}
        }
}

