#!/usr/bin/env kjscmd

//
// Script demonstrating how to create a custom widget.
//

function createField( parent )
{
    var hbox = new QHBox( box, 'hb' );

    var label = new QLabel( hbox );
    label.text = 'Filename:';
    var ed = new QLineEdit( hbox, 'lineed' );
    ed.text = './my_file.txt';
    var pb = new QPushButton( hbox, 'button' );
    pb.text = 'Br&owse';
    var led = new KLed( hbox, 'led' );
}

function createGroup( parent )
{
    var grp = new QGroupBox( box, 'grp' );
    grp.columns = 1;
    grp.title = 'A QGroupBox';
	
    var cb1 = new QCheckBox( grp, 'check1' );
    var cb2 = new QCheckBox( grp, 'check2' );
    cb1.text = 'Check Box One';
    cb2.text = 'Check Box Two';

    return grp;
}

// Outer layout
var box = new QVBox();
box.margin = 6;

// Title
var ttl = new QLabel( box, 'title' );
ttl.text = '<qt><center><h3>KJSEmbed Object Creation Demo</h3></center><hr></qt>';

// Named field
createField( box );

// Text editor
var l = new QLabel( box, 'tl' );
l.txt = 'Editable Text Widget:';
var txt = new QTextEdit( box, 'text_edit' );
txt.text = '<qt>This is an editable text widget created from <i>Javascript</i> using the '
         + '<b>KJSEmbed</b> library. As you can see, the facilities are powerful enough '
         + 'for many useful applications to be found.</qt>';

// Group of check boxes
var grp = createGroup( box );

box.show();
application.exec();
