//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import java.util.ArrayList;

/**

 Manages the filtering of URIs.
 The intention of this plugin class is to allow people to extend the
 functionality of KURL without modifying it directly. This way KURL will
 remain a generic parser capable of parsing any generic URL that adheres
 to specifications.
 The KURIFilter class applies a number of filters to a URI and returns the
 filtered version whenever possible. The filters are implemented using
 plugins to provide easy extensibility of the filtering mechanism. New
 filters can be added in the future by simply inheriting from
 KURIFilterPlugin and implementing the KURIFilterPlugin.filterURI
 method.
 Use of this plugin-manager class is straight forward.  Since it is a
 singleton object, all you have to do is obtain an instance by doing
 <code>KURIFilter</code>.self() and use any of the public member functions to
 preform the filtering.
 <b></b>xample
 To simply filter a given string:
 <pre>
 boolean filtered = KURIFilter.self().filterURI( "kde.org" );
 </pre>
 You can alternatively use a KURL:
 <pre>
 KURL url = "kde.org";
 boolean filtered = KURIFilter.self().filterURI( url );
 </pre>
 If you have a constant string or a constant URL, simply invoke the
 corresponding function to obtain the filtered string or URL instead
 of a booleanean flag:
 <pre>
 String u = KURIFilter.self().filteredURI( "kde.org" );
 </pre>
 You can also restrict the filter(s) to be used by supplying
 the name of the filter(s) to use.  By defualt all available
 filters will be used. To use specific filters, add the names
 of the filters you want to use to an ArrayList and invoke
 the appropriate filtering function. The examples below show
 the use of specific filters. The first one uses a single
 filter called kshorturifilter while the second example uses
 multiple filters:
 <pre>
 String text = "kde.org";
 boolean filtered = KURIFilter.self().filterURI( text, "kshorturifilter" );
 </pre>
 <pre>
 ArrayList list;
 list << "kshorturifilter" << "localdomainfilter";
 boolean filtered = KURIFilter.self().filterURI( text, list );
 </pre>
 KURIFilter also allows richer data exchange through a simple
 meta-object called <code>KURIFilterData.</code> Using this meta-object
 you can find out more information about the URL you want to
 filter. See KURIFilterData for examples and details.
		@short Filters a given URL into its proper format whenever possible.

*/
public class KURIFilter implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KURIFilter(Class dummy){}

	/**	
		 Filters the URI given by the object URIFilterData.
			 The given URL is filtered based on the specified list of filters.
		 If the list is empty all available filters would be used.
			@param data object that contains the URI to be filtered.
			@param filters specify the list of filters to be used.
				@return a boolean indicating whether the URI has been changed
     
		@short    Filters the URI given by the object URIFilterData.
	*/
	public native boolean filterURI(KURIFilterData data, String[] filters);
	public native boolean filterURI(KURIFilterData data);
	/**	
		 Filters the URI given by the URL.
			 The given URL is filtered based on the specified list of filters.
		 If the list is empty all available filters would be used.
			@param uri the URI to filter.
			@param filters specify the list of filters to be used.
				@return a boolean indicating whether the URI has been changed
     
		@short    Filters the URI given by the URL.
	*/
	public native boolean filterURI(KURL uri, String[] filters);
	public native boolean filterURI(KURL uri);
	/**	
		 Filters a string representing a URI.
			 The given URL is filtered based on the specified list of filters.
		 If the list is empty all available filters would be used.
			@param uri The URI to filter.
			@param filters specify the list of filters to be used.
				@return a boolean indicating whether the URI has been changed
     
		@short    Filters a string representing a URI.
	*/
	public native boolean filterURI(StringBuffer uri, String[] filters);
	public native boolean filterURI(StringBuffer uri);
	/**	
		 Returns the filtered URI.
			 The given URL is filtered based on the specified list of filters.
		 If the list is empty all available filters would be used.
			@param uri The URI to filter.
			@param filters specify the list of filters to be used.
				@return the filtered URI or null if it cannot be filtered
     
		@short    Returns the filtered URI.
	*/
	public native KURL filteredURI(KURL uri, String[] filters);
	public native KURL filteredURI(KURL uri);
	/**	
		 Return a filtered string representation of a URI.
			 The given URL is filtered based on the specified list of filters.
		 If the list is empty all available filters would be used.
			@param uri the URI to filter.
			@param filters specify the list of filters to be used.
				@return the filtered URI or null if it cannot be filtered
     
		@short    Return a filtered string representation of a URI.
	*/
	public native String filteredURI(String uri, String[] filters);
	public native String filteredURI(String uri);
	/**	
		 Return an iterator to iterate over all loaded
		 plugins.
				@return a plugin iterator.
     
		@short    Return an iterator to iterate over all loaded  plugins.
	*/
	// QPtrListIterator<KURIFilterPlugin> pluginsIterator(); >>>> NOT CONVERTED
	/**	
		 Return a list of the names of all loaded plugins.
				@return an ArrayList of plugin names

		@short    Return a list of the names of all loaded plugins.
	*/
	public native ArrayList pluginNames();
	/**	
		 Returns an instance of KURIFilter.
		     		@short    Returns an instance of KURIFilter.
	*/
	public static native KURIFilter self();
	/**	
		 A protected constructor.
			 This constructor creates a KURIFilter and
		 initializes all plugins it can find by invoking
		 loadPlugins.
		     		@short    A protected constructor.
	*/
	public KURIFilter() {
		newKURIFilter();
	}
	private native void newKURIFilter();
	/**	
		 Loads all allowed plugins.
			 This function loads all filters that have not
		 been disbled.
		     		@short    Loads all allowed plugins.
	*/
	protected native void loadPlugins();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
