class Q_EXPORT QSize
{
public:
    QSize();
    QSize( const QSize& size )
    QSize( int w, int h );

    bool   isNull()	const;
    bool   isEmpty()	const;
    bool   isValid()	const;

    int	   width()	const  prop(width);
    int	   height()	const  prop(height);
    void   setWidth( int w ) prop(width);
    void   setHeight( int h ) prop(height);
    void   transpose();

    QSize expandedTo( const QSize & ) const;
    QSize boundedTo( const QSize & ) const;

    QSize &operator+=( const QSize & );
    QSize &operator-=( const QSize & );
    QSize &operator*=( int c );
    QSize &operator*=( double c );
    QSize &operator/=( int c );
    QSize &operator/=( double c );

    friend inline bool	operator==( const QSize &, const QSize & );
    friend inline bool	operator!=( const QSize &, const QSize & );
    friend inline QSize operator+( const QSize &, const QSize & );
    friend inline QSize operator-( const QSize &, const QSize & );
    friend inline QSize operator*( const QSize &, int );
    friend inline QSize operator*( int, const QSize & );
    friend inline QSize operator*( const QSize &, double );
    friend inline QSize operator*( double, const QSize & );
    friend inline QSize operator/( const QSize &, int );
    friend inline QSize operator/( const QSize &, double );
};
