package org.kde.DCOP;


public class Client
{
    // attach to DCOP server as 'anonymous'
    public native boolean attach();

    // attach to DCOP server using appName as key  
    public native String registerAs(String appName);
  
    // report if we are registered at the server
    public native boolean isRegistered();

    // return the registered application id
    public native String appId();

    // suspend DCOP processing
    public native void suspend();

    // resume DCOP processing
    public native void resume();

    // detach from the DCOP server
    public native boolean detach();

    // report if we are attached to DCOP server
    public native boolean isAttached();

    // send a command to the server
    public native boolean send(String remApp, String remObj, String remFun, byte[] data);

    // send a command string to the server
    public native boolean send(String remApp, String remObj, String remFun, String data);

    // call a function and get the result
    public native Response call(String remApp, String remObj, String remFun, byte[] data, boolean eventLoop);
    
	// Checks whether remApp is registered with the DCOP server.
	public native boolean isApplicationRegistered ( String remApp);
  
    public static void main(String[] args) 
    {
	Client client = new Client();

	System.out.println("Registering as: " + client.registerAs("Java-App"));
	if (client.isAttached())
	    System.out.println("Attached!");

	client.send("kdesktop", "KDesktopIface", "selectAll()", "");

	java.io.ByteArrayOutputStream bs = new java.io.ByteArrayOutputStream();
	Response res = client.call("kdesktop", "KDesktopIface", "selectedURLs()", bs.toByteArray(), false);
	System.out.println("Result type: " + res.returnType);
    }
  
    static 
    {
	System.loadLibrary("javadcop");  
    }

}

