/*
 *   Copyright (C) 2000 Matthias Elter <elter@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __treeview_h__
#define __treeview_h__

#include <qstring.h>
#include <klistview.h>

class QPopupMenu;


class TreeItem : public QListViewItem
{
    bool parsed;
    bool directory;
    QString path;
    QString exec;
    QString dEntry;

protected:
    QString key(int column, bool ascending) const;

    void init(const QPixmap& pixmap, bool parse, bool dir, const QString& _path, const QString& _exec, const QString& _dEntry);

public:
    TreeItem( KListView* parent, const QString & name, const QPixmap& pixmap,
                      bool parse, bool dir, const QString& p, const QString& c, const QString& dE );
    TreeItem( QListViewItem* parent, const QString & name, const QPixmap& pixmap,
                      bool parse, bool dir, const QString& p, const QString& c, const QString& dE );
    bool isDirectory();

    QString desktopEntryPath() const { return dEntry; }
    QString executable() const { return exec; }

protected:
    virtual void activate();
    virtual void setOpen( bool o );

    friend class TreeView;
};

/* ------------------------------------------------------------------------- */

/**
 * @internal
 */
class TreeView : public KListView
{
    Q_OBJECT
public:
    TreeView( QWidget *parent, const char* name = 0 );

    /**
     * Add a group of .desktop/.kdelnk entries
     */
    void addDesktopGroup( QString relPath, TreeItem *item = 0 );

    bool isDirSel();

protected:
    void resizeEvent( QResizeEvent *_ev );
    TreeItem* currentitem;

};

#endif
